


export class UserEditWidget {
	
	tpl = `
		<div class="user-edit-widget">
			<div class="page-header">
				<div class="toolbox">
				
					<span ez-if="popupMode == false">
						<a href="{{appUrl('/masterdata/users/')}}" class="fa fa-chevron-circle-left"></a>
						
						<span ez-if="user.userId > 0">
							<a href="javascript:void(0);" [onclick]="widget.deleteUser" class="fa fa-trash delete-user"></a>
						</span>
					</span>
					
					<span ez-if="popupMode == true">
						<a onclick="close_popup();" class="fa fa-times-circle"></a>
					</span>
					
					<a href="javascript:void(0);" [onclick]="widget.saveUser" class="fa fa-save"></a>
				</div>
				<h1>{{!user.userId?'Nieuwe gebruiker':'Bewerk gebruiker'}}</h1>
			</div>
			
			<div class="action-box">
				<span ez-if="isNew == false"><a [onclick]="widget.resetPasswordMail_Click">{{_('Reset Password Mail')}}</a></span>
			</div>
			
			
			<form id="frmUser" action="{{appUrl('/service/users.do')}}">
			<div class="accordion">
				<div class="accordion-item">
					<h2 class="accordion-header"><button type="button" class="accordion-button hide-button-icon">Basisgegevens</button></h2>
					<div class="accordion-collapse collapse show">
						<div class="accordion-body">
							<input type="hidden" name="a" value="save" />
				
							<input type="hidden" name="user_id" value="{{user.userId}}" />
				
							<ez-checkbox name="activated" label="Actief" [checked]="user.activated"></ez-checkbox>
							
							<ez-select name="userType" label="Gebruikerstype" [value]="user.userType">
								<option value="admin">Administrator</option>
								<option value="user">Gebruiker</option>
							</ez-select>
			
							<ez-text name="username" label="Gebruikersnaam" [value]="user.username"></ez-text>
				
							<ez-password name="password" label="Wachtwoord"></ez-password>
				
							<ez-email name="email" label="E-mail" [value]="user.email"></ez-email>
				
							<ez-text name="firstname" label="Voornaam" [value]="user.firstname"></ez-text>
				
							<ez-text name="lastname" label="Achternaam" [value]="user.lastname"></ez-text>
				
							<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="user.edited"></ez-datetime-text>
				
							<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="user.created"></ez-datetime-text>
						</div>
					</div>
				</div>
				
				<div class="accordion-item" id="permissions-container" ez-if="userPermissions.length > 0">
					<h2 class="accordion-header"><button type="button" class="accordion-button hide-button-icon">Permissies</button></h2>
					<div class="accordion-collapse show">
						<div class="accordion-body">
							<table>
							<tbody ez-for="userPermissions" ez-item="up">
								<tr>
									<td style="width: 100px;">{{up.label}}</td>
									<td>
										<span ez-for="up.values" ez-item="upv">
											<label>
												<input type="radio" class="user-permission" name="up.{{up.name}}" value="{{upv.value}}" [checked]="upv.selected" />
												{{upv.label}}
											</label>
										</span>
									</td>
								</tr>
							</tbody>
							
							</table>
						</div>
					</div>
				</div>
				
				
				<div class="accordion-item" id="user-group-container" ez-if="groups.length > 0">
					<h2 class="accordion-header"><button type="button" class="accordion-button hide-button-icon">Gekoppelde groepen</button></h2>
					<div class="accordion-collapse show">
						<div class="accordion-body">
							<div ez-for="groups" ez-item="g">
								<div>
									<label>
										<input type="checkbox" [checked]="{{user.userGroupIds && user.userGroupIds.indexOf(g.userGroupId) != -1 ? 1 : 0}}"  id="user-group-id-{{g.userGroupId}}" name="group_id[]" value="{{g.userGroupId}}" />
										{{g.groupName}}
									</label>
								</div>
							</div>
						</div>
					</div>
				</div>
				
			</div>
			</form>
		</div>
	`;
	
	container = null;
	loading = false;
	
	popupMode = false;
	
	ezTpl = null;
	groups = [];
	user = {
		userId: '',
		activated: true,
		username: '',
		userType: 'user'
	};
	
	
	userPermissions = [];
	
	callbackUserCreated = null;

	setCallbackUserCreated(callback) {
		this.callbackUserCreated = callback;
	}

	
	
	init(e) {
		this.container = e;
		
		this.userPermissions = apply_filter( 'MasterData.UserEditWidget.userPermissions', [] );
		
		let id = getUrlParam('id');
		
		if (id) {
			this.loadUser( id );
		}
		else {
			this.loadGroups();
			this.render();
		}
	}
	
	render() {
//		console.log( this.tpl );

		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('isNew', !this.user || !this.user.userId ? true : false);
		this.ezTpl.setVar('user', this.user);
		this.ezTpl.setVar('groups', this.groups);
		this.ezTpl.setVar('popupMode', this.popupMode);
		this.ezTpl.setVar('userPermissions', this.userPermissions);
		this.ezTpl.render();
		
		$(this.container).find('[name=userType]').on('change', function() {
			this.toggleLinkedGroups();
			this.togglePermissions();
			
		}.bind(this));
		this.toggleLinkedGroups();
		this.togglePermissions();
		
		
		if (this.user.userId == 1 || this.user.username == 'admin') {
			$('[name=activated], [name=userType], [name=username]').attr('disabled', 'disabled');
			$('.delete-user').remove();
		}
		
		window.dispatchEvent( new Event('UserEditWidget.render') );
	}
	
	toggleLinkedGroups() {
		// always show user-group-container.. idea is that linked groups are automatically
		// added as permissions to new records. If an admin-user is used, also auto-link 
		// it's groups
		return;
		
		if ( this.groups.length == 0 )
			return;
		
		let ut = $('select[name=userType]').val();
		
		console.log(ut);
		
		if (ut == 'admin') {
			document.getElementById('user-group-container').style.display='none';
		}
		else {
			document.getElementById('user-group-container').style.display='';
		}
	}


	togglePermissions() {
		let ut = $('select[name=userType]').val();
		
		if (ut == 'admin') {
			document.getElementById('permissions-container').style.display='none';
		}
		else {
			document.getElementById('permissions-container').style.display='';
		}
	}
	
	
	saveUser() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		postForm('#frmUser').then(async function(e) {
			let json = await e.json();
//			console.log( json );
			
			if (json.error) {
				// TODO: render errors
				formShowErrors( '#frmUser', json );
				
			}
			else {
				
				let user_evt = new Event('UserEditWidget.saveUser');
				user_evt.response = json;
				window.dispatchEvent( user_evt );
				
				
				if (this.popupMode == false) {
					// report succesfully saved
					reportUserMessage( 'Wijzigingen opgeslagen' );
					
					// reload data?
					replaceRoute( '/masterdata/users/edit/?id=' + json.user.userId );
				}
				
				if (this.popupMode == true) {
					this.callbackUserCreated( json.user );
					
					close_popup();
				}
			}
			
			this.loading = false;
		}.bind(this)).catch(showErrorWidget);
	}
	
	
	deleteUser() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je deze gebruiker wilt verwijderen?', function() {
			postUrl('/service/users.do', {
				a: 'delete',
				userId: this.user.userId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showAlert('Error', 'Er is een fout opgetreden: ' + json.message);
					return;
				}
				
				gotoRoute( '/masterdata/users/' );
			}.bind(this));
		}.bind(this));
	}
	
	loadGroups() {
		postUrl( '/service/users.do', {
			a: 'groups'
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.groups  = json;
			this.render();
			
			this.loading = false;
		}.bind(this) );
	}
	
	async loadUser(userId) {
		let e = await postUrl( '/service/users.do', {
			a: 'view',
			userId: userId
		});
		
		let json = await e.json();
		if (json.error) {
			return showErrorWidget(json);
		}
		
		this.user = json.user;
		this.groups  = json.groups;
		
		this.updateUserPermissions( this.user );
		
		this.render();
		
		this.loading = false;
		
		window.dispatchEvent( new Event('UserEditWidget.userLoaded') );
	}
	
	updateUserPermissions( user ) {
		let permissionMap = {};
		for(let i=0; i < user.permissions.length; i++) {
			let refObj = user.permissions[i].refObject;
			let am = user.permissions[i].accessMethod;
			permissionMap[refObj] = am;
		}
		
		for(let i=0; i < this.userPermissions.length; i++) {
			
			let n = 'up.'+this.userPermissions[i].name;
			
			if (typeof permissionMap[n] == 'undefined') continue;
			
			let v = permissionMap[n];
			
			
			for(let j=0; j < this.userPermissions[i].values.length; j++) {
				if (this.userPermissions[i].values[j].value == v)
					this.userPermissions[i].values[j].selected = true;
				else
					this.userPermissions[i].values[j].selected = false;
			}
		}
	}
	
	
	
	resetPasswordMail_Click() {
		
		
		if (validate_email( $('input[name=email]').val() ) == false) {
			showAlert(_('Error'), _('No e-mailadres configured'));
			return;
		}
		
		
		showConfirmation(_('Send reset password mail'), _('Are you sure to send this user a reset password mail?'), async () => {
			showLoadingForm('#frmUser');
			
			try {
				let r = await postJson('/service/users.do', {
					a: 'resetPasswordMail',
					userId: this.user.userId
				});
				
				let json = await r.json();
				
				if (json.success) {
					reportUserMessage(_('E-mail sent'));
				}
				else if (json.message) {
					reportUserError('Error: ' + json.message);
				}
				else {
					reportUserError('Unknown error occurred');
				}
			}
			catch (err) {
				reportUserError('Error: ' + err.message);
			}
			
			hideLoadingForm('#frmUser');
		});
		
		
	}
	
	

	showPopup() {
		let d = show_popup('Add user', '');
		
		this.popupMode = true;
		
		this.init(d);
	}
	
}


