



export class ArticleListWidget {
	
	container = null;
	articles = null;
	response = null;
	
	ezTpl = null;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="{{appUrl('/masterdata/sales/article/edit/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Artikelen</h1>
		</div>
		
		<div ez-if="articles == null">
			Loading...
		</div>
		<div ez-if="articles != null">
			<table class="table">
				<thead>
					<tr>
						<th>Omschrijving</th>
						<th style="width: 220px;">Prijs</th>
						<th style="width: 80px;">Verhuur</th>
						<th style="width: 80px;">Actief</th>
						<th style="width: 140px;">Laatst bewerkt</th>
						<th style="width: 80px;"></th>
					</tr>
				</thead>
				<tbody  ez-for="articles" ez-item="art" class="tbody-articles">
					<tr [onclick]="widget.editArticle" class="pointer" article-id="{{art.articleId}}">
						<td>{{art.shortDescription}}</td>
						<td>
							<span ez-if="art.pricingMethod == 'slotplan'">
								<div ez-for="art.slotplanPrices" ez-item="sp">
									<div>
										{{sp.displayPrice}},
										{{sp.slotplanPricetypeName}}
									</div>
								</div>
							</span>
							<span ez-if="art.pricingMethod != 'slotplan'">
								{{ art.priceDescription }}
							</span>
						</td>
						<td>{{art.rentable ? 'Ja' : 'Nee'}}</td>
						<td>{{art.active ? 'Ja' : 'Nee'}}</td>
						<td>{{ format_datetime(art.edited, {dmy: true}) }}</td>
						<td class="actions">
							<a href="{{appUrl('/masterdata/sales/article/edit/?id='+art.articleId)}}" class="fa fa-pencil"></a>
						</td>
					</tr>
				</tbody>
					
				<tbody ez-if="articles.length == 0">
					<tr>
						<td colspan="6" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
			
			<ez-pager></ez-pager>
		</div>
	`;
	
	
	editArticle(evt, tr) {
		let artId = tr.getAttribute('article-id');
		
		gotoRoute( '/masterdata/sales/article/edit/?id='+artId );
	}


	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('articles', this.articles);
		this.ezTpl.setVar('response', this.response);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();

		
	}
	
	
	loadArticles() {
		postUrl( '/service/sales/article.do' ).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.articles = json.articles;
			this.response = json;
			
			this.render();
			
		}.bind(this));
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadArticles();
	}

}

