


export class RentalContractSummaryWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.goBack_Click" class="fa fa-chevron-circle-left"></a>
			</div>
			
			<h1>{{_('Summary')}}</h1>
		</div>
		
		
		<div class="action-box">
			<span><a href="javascript:void(0);" [onclick]="widget.createOffer_Click">{{_('Create offer')}}</a></span>
			
			<span><a href="javascript:void(0);" [onclick]="widget.createContract_Click">{{_('Create contract')}}</a></span>
		</div>
		
		
		<div class="contract-summary">
		
		</div>
		
	`;
	
	
	
	
	
	container = null;
	ezTpl = null;
	
	
	init(e) {
		
		this.container = e;
		
		this.render();
	}
	
	goBack_Click() {
		let uuid = getUrlParam('uuid');
		
		gotoRoute( '/sales/rental/selectCustomer/?uuid=' + uuid );
	}
	
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.render();
	}
	
	
	
	
	goBack_Click() {
		let uuid = getUrlParam('uuid');
		
		let url = '/sales/rental/new/?uuid=' + uuid;
		gotoRoute( url );
	}
	
	
	
	createContract_Click() {
		showLoadingForm( '.contract-summary' );
		
		let uuid = getUrlParam('uuid');
		let wizard = getSession('rental-' + uuid);
		
		
		wizard.a = 'createContract';
		
		postJson( '/service/sales/rental/rental.do', wizard ).then(async (c) => {
			
			let json = await c.json();
			
			console.log('response', c);
			
			reportUserMessage( _('Contract created') );

			gotoRoute( '/sales/rental/edit/?id=' + json.rentalContractId );
		}).catch((err) => {
			console.error('Error', err);
		});
	}
	
	
	createOffer_Click() {
		showLoadingForm( '.contract-summary' );
		
		let uuid = getUrlParam('uuid');
		let wizard = getSession('rental-' + uuid);
		
		
		wizard.a = 'createOffer';
		
		postJson( '/service/sales/rental/rental.do', wizard ).then(async (c) => {
			
			let json = await c.json();
			
			console.log('response', c);
			
			reportUserMessage( _('Offer created') );

			gotoRoute( '/sales/offer/edit/?id=' + json.offerId );
		}).catch((err) => {
			console.error('Error', err);
		});
	}
	
	
	
	
}

