

export class RentalCalendarOccupationWidget {
	
	
	tpl = `
		<div style="display: flex;">
			<a class="fa fa-chevron-left" style="padding: 5px 10px" [onclick]="widget.prev_Click"></a>
			<div class="rental-date-container"></div>
			<a class="fa fa-chevron-right" style="padding: 5px 10px" [onclick]="widget.next_Click"></a>
		</div>
	`;
	
	
	container = null;
	articleId = null;
	
	startMonth = null;
	monthsShown = 3;
	
	lines = [];
	
	callbackDateSelected = null;
	
	
	constructor( ) {
		
	}
	
	setArticleId( articleId ) { this.articleId = articleId; }
	setStartMonth( m ) { this.startMonth = m; }
	
	async init(e) {
		this.container = e;
		
		await this.loadOccupation();
		
		this.render();
	}
	
	setDateSelected( clb ) { this.callbackDateSelected = clb; }
	
	
	prev_Click() {
		this.startMonth = previous_month( this.startMonth );
		this.render();
	}
	next_Click() {
		this.startMonth = next_month( this.startMonth );
		this.render();
	}
	
	
	async loadOccupation() {
		let sd = this.startMonth;
		if (valid_date(sd) == false) {
			sd = format_date( new Date() );
			this.startMonth = sd;
		}
		
		let r = await postJson('/service/sales/rental/rental.do', {
			a: 'occupationByPeriod',
			articleId: this.articleId,
			startDate: start_of_month( sd ),
			endDate: end_of_month( next_month( sd, this.monthsShown ) )
		});
		
		let json = await r.json();
		
		this.lines = json.lines;
	}
	
	
	hasOccupation( d ) {
		
		let ymd = date2ymd( d );
		
		for(let i in this.lines) {
			let l = this.lines[i];
			
			
			if ( valid_date(l.startDate) == false || date2ymd(l.startDate) < ymd ) {
				if (valid_date(l.endDate) == false || date2ymd(l.endDate) > ymd) {
					return true;
				}
			}
			
		}
		
		
		return false;
	}
	
	
	buildMonth( date ) {
		let d = str2date( start_of_month( date ) );
		
		
		let tbl = document.createElement('table');
		tbl.className = 'tbl-rental-occupation';
		
		let thead = document.createElement('thead');
		
		// month name
		let trmonthname = document.createElement('tr');
		let tdmonthname = document.createElement('td');
		tdmonthname.innerText = _('month.'+(d.getMonth()+1)) + ' ' + d.getFullYear();
		tdmonthname.setAttribute('colspan', 7);
		
		trmonthname.appendChild(tdmonthname);
		thead.appendChild( trmonthname );
		tbl.append(thead);
		
		// days
		let td1 = document.createElement('td');
		td1.innerText = 'ma';
		let td2 = document.createElement('td');
		td2.innerText = 'di';
		let td3 = document.createElement('td');
		td3.innerText = 'wo';
		let td4 = document.createElement('td');
		td4.innerText = 'do';
		let td5 = document.createElement('td');
		td5.innerText = 'vr';
		let td6 = document.createElement('td');
		td6.innerText = 'za';
		let td7 = document.createElement('td');
		td7.innerText = 'zo';
		
		let trdays = document.createElement('tr');
		trdays.appendChild( td1 );
		trdays.appendChild( td2 );
		trdays.appendChild( td3 );
		trdays.appendChild( td4 );
		trdays.appendChild( td5 );
		trdays.appendChild( td6 );
		trdays.appendChild( td7 );
		thead.appendChild( trdays );
		
		
		let tbody = document.createElement('tbody');
		tbl.appendChild( tbody );
		
		
		let startMonth = d.getMonth();	// this is 0-11..
		
		while ( d.getDay() != 1 ) {
			d = str2date( previous_day( d ) );
		}
		
		
		
		do {
			let trweek = document.createElement('tr');
			for(let i=0; i < 7; i++) {
				let tdday = document.createElement('td');
				tdday.innerText = d.getDate();
				tdday.date = d;
				
				if (this.hasOccupation( d )) {
					tdday.className += ' occupied ';
				}
				else {
					tdday.className += ' arrival ';
					
					tdday.addEventListener('click', (evt) => {
						
						if ( this.callbackDateSelected ) {
							this.callbackDateSelected( evt.target.date );
						}
					})
				}
				
				trweek.appendChild( tdday );
				
				d = str2date( next_day(d) );
			}
			tbody.appendChild( trweek );
		} while ( d.getMonth() == startMonth );
		
		return tbl;
	}
	
	
	
	
	render() {
//		$( this.container ).empty();
		
		let eztpl = new EzTemplate( this.container )
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.render();
		
		
		let tbl1 = this.buildMonth( this.startMonth );
		document.querySelector('.rental-date-container').appendChild( tbl1 );
		
		let tbl2 = this.buildMonth( next_month(this.startMonth, 1) );
		document.querySelector('.rental-date-container').appendChild( tbl2 );
		
		let tbl3 = this.buildMonth( next_month(this.startMonth, 2) );
		document.querySelector('.rental-date-container').appendChild( tbl3 );
		
		
		
	}
	
	
}


