

import { RentalCalendarOccupationWidget } from './RentalCalendarOccupationWidget.js';
import { RentalSlotOccupationWidget } from './RentalSlotOccupationWidget.js';


export class RentalContractConfigureWidget {
	
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" onclick="close_popup();" class="fa fa-times-circle"></a>
				<a href="javascript:void(0);" [onclick]="widget.saveContract_Click" class="fa fa-save"></a>
			</div>
			
			<h1>{{article.shortDescription}}</h1>
		</div>
		
		<div class="configure-container">
			<div ez-if="article.pricingMethod == 'fixed' || article.pricingMethod == 'week' || article.pricingMethod == 'month' || article.pricingMethod == 'dayprice'">
				<ez-date name="startDate" label="{{_('Start date')}}" [value]="startDate"></ez-date>
				
				<div style="display: flex;">
					<ez-date name="endDate" label="{{_('End date')}}" [value]="endDate"></ez-date>
					<div>
						<a style="padding: 10px 3px;" class="fa fa-minus" [onclick]="widget.minPeriod_Click"></a>
						<a style="padding: 10px 3px;" class="fa fa-plus" [onclick]="widget.plusPeriod_Click"></a>
					</div>
				</div>
				
				<ez-price name="price" 
							[value]="price" 
							label="Prijs {{salesSettings.inputPrice == 'excl_vat' ? '(excl.)' : '' }} {{salesSettings.inputPrice == 'incl_vat' ? '(incl.)' : '' }} / {{_('pricingmethod.'+article.pricingMethod)}}"
							></ez-price>
				
				
				<div style="height: 5px;"></div>
				<ez-checkbox name="autoRenewal" 
							checked="1"
							label="Automatisch verlengen"
							[onchange]="widget.autoRenewal_Change"></ez-checkbox>
				
				<div class="auto-renewal-input">
					<div style="display: flex;">
						<ez-number name="timeNotice"
									[value]="timeNotice"
									label="{{_('Notice period')}}"></ez-number>
						<span class="input-note"> / {{_('pricingmethod.'+article.pricingMethod)}}</span>
					</div>
					<div style="display: flex;">
						<ez-number name="renewalPeriod"
									min="1"
									[value]="renewalPeriod"
									[onchange]="widget.renewalPeriod_Change"
									label="{{_('Renewal period')}}"></ez-number>
						<span class="input-note"> / {{_('pricingmethod.'+article.pricingMethod)}}</span>
					</div>
				</div>
				
			</div>
			
			<div ez-if="article.pricingMethod == 'hour' || article.pricingMethod == 'slotplan'">
			<!--
				<ez-datetime name="startDatetime" 
								label="{{_('Start time')}}" 
								[onchange]="widget.startDatetime_Change"
								[value]="startDate"></ez-datetime>
				
				<ez-datetime name="endDatetime" label="{{_('End time')}}" [value]="endDate"></ez-datetime>
				-->
			</div>
		</div>
		
		<div class="configure-article-occupation"></div>
	`;
	
	
	articleId = null;
	article = null;
	salesSettings = null;
	
	startDate = null;
	endDate = null;
	
	autoRenewal = true;
	timeNotice = 0;
	renewalPeriod = 1;
	
	callbackAddContract = null;
	
	rentalSlotOccupationWidget = null;
	
	
	init( articleId ) {
		this.articleId = articleId;
		
		this.startDate = new Date();
		
		this.loadArticle();
	}
	
	async initArticle( article ) {
		this.article = article;
		this.articleId = article.articleId;
		
		this.startDate = article.startDate;
		this.endDate = article.endDate;
		
		this.autoRenewal = article.autoRenewal ? true : false;
		this.timeNotice = article.timeNotice;
		this.renewalPeriod = article.renewalPeriod;
		
		
		let r = await postJson('/service/sales/settings.do');
		let json = await r.json();
		
		this.salesSettings = json.settings;

		this.render();

		this.loadOccupation();
	}
	
	setAddContract( callback ) {
		this.callbackAddContract = callback;
	}
	
	
	async loadArticle() {
		let response = await postJson( '/service/sales/rental/rental.do', {
			a: 'articleRentalInfo',
			articleId: this.articleId
		});
		
		let json = await response.json();
		
		this.article = json.article;
		this.salesSettings = json.salesSettings;
		
		this.initVars();
		
		this.render();
		
		this.loadOccupation();
	}
	
	
	minPeriod_Click() {
		let sd = elval('.configure-container input[name=startDate]');
		if (!sd) sd = format_date(new Date());
		
		let ed = elval('.configure-container input[name=endDate]');
		
		// handling week
		if (this.article.pricingMethod == 'week') {
			let weeksBetween = null;
			if (ed)
				weeksBetween = weeks_between( sd, ed );
			
			if (isNaN(weeksBetween) == false) weeksBetween--;
			
			if (!weeksBetween || weeksBetween <= 0)
				weeksBetween = 1;
			
			this.endDate = next_week( sd, weeksBetween );
		}
		// handling month
		else if (this.article.pricingMethod == 'month') {
			this.startDate = format_date(new Date());
			
			let monthsBetween = null;
			if (ed) {
				monthsBetween = months_between( sd, ed );
			}
			
			if (isNaN(monthsBetween) == false)
				monthsBetween--;
			
			if (!monthsBetween || monthsBetween <= 0)
				monthsBetween = 0;
			
			
			// determine end
			if (this.salesSettings.startMonthInvoice == 'begin_month') {
				this.endDate = end_of_month( this.startDate );
				
				if (ed && monthsBetween > 0) {
					this.endDate = next_month( this.endDate, monthsBetween );
				}
			}
			if (this.salesSettings.startMonthInvoice == 'start_contract') {
				if (monthsBetween <= 0) monthsBetween = 1;
				
				this.endDate = next_month( this.startDate, monthsBetween );
			}
		}
		
		setval('.configure-container input[name=endDate]', format_date(this.endDate, {dmy:true}));
	}
	plusPeriod_Click() {
		let sd = elval('.configure-container input[name=startDate]');
		if (!sd) sd = format_date(new Date());
		
		let ed = elval('.configure-container input[name=endDate]');
		
		// handling week
		if (this.article.pricingMethod == 'week') {
			if (ed) {
				let weeksBetween = null;
				weeksBetween = weeks_between( sd, ed );
			
				if (!weeksBetween || weeksBetween <= 0)
					weeksBetween = 1;
				
				this.endDate = next_week( sd, weeksBetween+1 );
			}
			else {
				this.endDate = next_week( sd, 1 );
			}
			
		}
		// handling month
		else if (this.article.pricingMethod == 'month') {
			this.startDate = format_date(new Date());
			
			let monthsBetween = null;
			if (ed) {
				monthsBetween = months_between( sd, ed );
			}
			
			if (!monthsBetween || monthsBetween <= 0)
				monthsBetween = 0;
			
			monthsBetween++;
			
			// determine end
			if (this.salesSettings.startMonthInvoice == 'begin_month') {
				this.endDate = end_of_month( this.startDate );
				
				if (ed && monthsBetween > 0) {
					this.endDate = next_month( this.endDate, monthsBetween );
				}
			}
			if (this.salesSettings.startMonthInvoice == 'start_contract') {
				this.endDate = next_month( this.startDate, monthsBetween );
			}
		}
		
		setval('.configure-container input[name=endDate]', format_date(this.endDate, {dmy:true}));
	}
	
	renewalPeriod_Change() {
		let p = parseInt( elval('.configure-container input[name=renewalPeriod]') );
		if (isNaN(p) || p <= 0) return;
		
		let sd = elval('.configure-container input[name=startDate]');
		if (!sd || !valid_date(sd)) retur;
		
		// handling week
		if (this.article.pricingMethod == 'week') {
			this.endDate = next_week( sd, p );
		}
		// handling month
		else if (this.article.pricingMethod == 'month') {
			// determine end
			if (this.salesSettings.startMonthInvoice == 'begin_month') {
				this.endDate = end_of_month( this.startDate );
				
				if (p > 1) {
					this.endDate = next_month( this.endDate, p-1 );
				}
			}
			if (this.salesSettings.startMonthInvoice == 'start_contract') {
				this.endDate = next_month( this.startDate, p );
			}
		}
		
		setval('.configure-container input[name=endDate]', format_date(this.endDate, {dmy:true}));
	}
	
	initVars() {
		if (this.article.pricingMethod == 'hour') {
		}
		else if (this.article.pricingMethod == 'week') {
			this.startDate = format_date(new Date());
			this.plusPeriod_Click();
		}
		else if (this.article.pricingMethod == 'month') {
			this.startDate = format_date(new Date());
			this.plusPeriod_Click();
		}
		else if (this.article.pricingMethod == 'slotplan') {
		}
		else if (this.article.pricingMethod == 'dayprice') {
			this.startDate = format_date(new Date());
		}
		else {
			
		}
	}
	
	loadOccupation() {
		if (this.article.pricingMethod == 'slotplan') {
			this.rentalSlotOccupationWidget = new RentalSlotOccupationWidget();
			this.rentalSlotOccupationWidget.setArticle( this.article );
			this.rentalSlotOccupationWidget.setStartDate( this.startDate );
			this.rentalSlotOccupationWidget.init( '.configure-article-occupation' );
			this.rentalSlotOccupationWidget.render();
		}
		
		if (this.article.pricingMethod == 'dayprice' || this.article.pricingMethod == 'week' || this.article.pricingMethod == 'month') {
			let w = new RentalCalendarOccupationWidget( );
			w.setArticleId( this.article.articleId );
			w.setStartMonth( this.startDate );
			w.setDateSelected( (d) => {
				this.startDate = format_date(d);
				setval('.configure-container input[name=startDate]', format_date(d, {dmy:true}));
				this.renewalPeriod_Change();
			});
			w.init( '.configure-article-occupation' );
			w.render();
		}
		
	}
	
	autoRenewal_Change(evt, inp) {
		let autoRenewal = inp.querySelector('input[type=checkbox]').checked;
		
		
		if (autoRenewal) {
			$('.configure-container .auto-renewal-input').show();
		}
		else {
			$('.configure-container .auto-renewal-input').hide();
		}
	}
	
	
	saveContract_Click() {
		
		// slotplan? => let slotplan widget handle it
		if ( this.article.pricingMethod == 'slotplan' ) {
			let lines = this.rentalSlotOccupationWidget.getRentalLines();
			if (this.callbackAddContract) {
				this.callbackAddContract( lines );
			}
			close_popup();
			return;
		}
		
		
		// other
		let c = $('.configure-container');
		
		let l = this.article;
		l.amount = 1;
		l.startDate = elval('.configure-container input[name=startDate]');
		l.endDate  = elval('.configure-container input[name=endDate]');
		l.autoRenewal = elval('.configure-container input[name=autoRenewal]');
		
		if (!this.article.originalDescription)
			this.article.originalDescription = this.article.shortDescription;
		
		l.shortDescription = this.article.originalDescription + ', ' + format_date(l.startDate, {dmy:true});
		if (valid_date(l.endDate)) {
			l.shortDescription += ' t/m ' + format_date(l.endDate, {dmy: true});
		}
		
		
		let price = elval('.configure-container input[name=price]');
		if (this.salesSettings.inputPrice == 'excl_vat') {
			l.priceExclVat = strtodouble( price );
		}
		if (this.salesSettings.inputPrice == 'incl_vat') {
			l.priceInclVat = strtodouble( price );
		}
		
		if (l.autoRenewal) {
			l.timeNotice = elval('.configure-container input[name=timeNotice]');
			l.renewalPeriod = elval('.configure-container input[name=renewalPeriod]');
		}
		else {
			l.timeNotice = 0;
			l.renewalPeriod = 0;
		}
		
		if (this.callbackAddContract) {
			this.callbackAddContract( [l] );
		}
		
		close_popup();
	}
	
	
	startDatetime_Change() {
		let sd = elval('.configure-container input[name=startDatetime]');
		
		let ed = elval('.configure-container input[name=endDatetime]');
		
		if (ed == '') {
			setval('.configure-container input[name=endDatetime]', sd);
		}
	}
	
	
	render() {
		// backdrop
		if ( !document.querySelector('.popup-background') ) {
			var bg = document.createElement('div');
			bg.className = 'popup-element popup-background';
			bg.addEventListener('click', () => {
				close_popup();
			});
			
			document.body.appendChild( bg );
		}
		
		let c = document.createElement('div');
		c.className = 'popup-element popup-container popup-bottom-sheet';
		document.body.appendChild( c );
		
		let tpl = new EzTemplate( c );
		tpl.loadHtml( this.tpl );
		tpl.setObject('widget', this);
		tpl.setVar('article', this.article);
		tpl.setVar('startDate', this.startDate);
		tpl.setVar('endDate', this.endDate);
		tpl.setVar('autoRenewal', this.autoRenewal);
		tpl.setVar('timeNotice', this.timeNotice);
		tpl.setVar('renewalPeriod', this.renewalPeriod);
		tpl.setVar('salesSettings', this.salesSettings);
		
		if (this.salesSettings.inputPrice == 'excl_vat') {
			tpl.setVar('price', this.article.priceExclVat);
		}
		else {
			tpl.setVar('price', this.article.priceInclVat);
		}
		
		tpl.render();
	}
	
	
	
}

