

import { showRentalArticleInfo } from '../../lib/RentalHelper.js';


loadCss('/static/app/widget/sales/css/rental-occupation.css');



export class RentalMonthlyView {
	
	
	tplDaily = `
		<table class="rental-monthly-view-days tbl-rentals">
			<thead>
				<tr class="month-list">
					<td></td>
					<td ez-forme="months" ez-item="m" colspan="{{m.days}}">
						{{_('month.'+m.month)}} - {{m.year}}
					</td>
				</tr>
				<tr class="day-list-name">
					<td></td>
					<td ez-forme="days" ez-item="d" class="{{d.date == today ? 'td-today' : '' }}">
						{{ _('daynoshort.' + str2date(d.date).getDay()) }}
					</td>
				</tr>
				<tr class="day-list">
					<td></td>
					<td ez-forme="days" ez-item="d" class="{{d.date == today ? 'td-today' : '' }}">
						{{ parseInt(d.date.substring(8)) }}
					</td>
				</tr>
			</thead>
			<tbody id="tbody-rental-articles">
			</tbody>
		</table>
	`;
	
	tplMonthly = `
		<table class="rental-monthly-view-month tbl-rentals">
			<thead>
				<tr class="month-list">
					<td></td>
					<td ez-forme="months" ez-item="m">
						{{_lc('monthshort.'+m.month)}} {{m.year}}
					</td>
				</tr>
			</thead>
			<tbody id="tbody-rental-articles">
			</tbody>
		</table>
	`;
	
	monthsToShow = 12;
	
	container = null;
	
	ezTpl = null;
	
	days = null;
	months = null;
	
	lastSearchResult = null;
	
	
	
	init(e) {
		this.container = e;
		
	}
	
	
	getMonth() {
		let d = document.querySelector('.container-settings input[name=d]').value;
		
		let date = str2date( d );
		if (!date)
			date = new Date();
		
		return date;
	}
	
	getStart() {
		return start_of_month( this.getMonth() );
	}
	getEnd() {
		let s = this.getStart();
		let n = next_month( s, this.monthsToShow-1 );
		
		return end_of_month( n );
	}
	
	
	colDates() {
		let m = this.getMonth();
		
		this.months = [];
		this.days = [];
		
		for(let i=0; i < this.monthsToShow; i++) {
			m = start_of_month(m);
			let dim = days_in_month( m );
			
			this.months.push({
				year: m.substr(0, 4),
				month: m.substr( 5, 2 ),
				days: dim,
				start_month: m
			});
			
			
			let startDay = m;
			for(let j=0; j < dim; j++) {
				this.days.push({
					date: startDay
				});
				
				startDay = next_day( startDay );
			}
			
			m = next_month( m, 1 );
		}
		
	}
	
	
	renderSearch( searchResult ) {
		
//		document.querySelector('#tbody-rental-articles').innerHTML = '';
		this.render();
		
		this.lastSearchResult = searchResult;
		
		let articles = searchResult.articles;
		
		for(let i=0; i < articles.length; i++) {
			let art = articles[i];
			this.addArticle( art );
		}
	}
	
	
	addArticle( art ) {
		
		if ( this.viewMode() == 'daily' ) {
			return this.addArticle_daily( art );
		}
		if ( this.viewMode() == 'monthly' ) {
			return this.addArticle_monthly( art );
		}
		
		
	}
	
	addArticle_daily( art ) {
		// row
		let tr = document.createElement('tr');
		tr.className = 'article-line';
		
		// label
		let td_desc = document.createElement('td');
		td_desc.className = 'article-description';
		td_desc.innerText = art.shortDescription;
		tr.appendChild( td_desc );
		
		// convert dates to ymd
		let dates = [];
		for(let i=0; i < art.rentalContractLines.length; i++) {
			let rcl = art.rentalContractLines[i];
			
			let ymdStart = date2ymd( rcl.startTime );
			let ymdEnd  = rcl.endTime ? date2ymd( rcl.endTime ) : null;
			
			dates.push({ ymdStart: ymdStart, ymdEnd: ymdEnd, rentalContractLine: rcl });
		}
		
		
		// generate TD's for days
		for(let i=0; i < this.days.length; i++) {
			let day = this.days[i];
			
			let d = date2ymd( day.date );
			
			let rentalContractLine = null;
			for(let i in dates) {
				if ( d >= dates[i].ymdStart && ( dates[i].ymdEnd == null || dates[i].ymdEnd >= d ) )
					rentalContractLine = dates[i].rentalContractLine;
			}
			
			
			let td = document.createElement('td');
			
			if (rentalContractLine) {
				td.className = 'occupied';
			}
			else {
				td.className = 'open';
			}
			let sp = document.createElement('span');
			sp.innerHTML = '&nbsp;';
			sp.onclick = () => {
				this.showRentalInfo( art.articleId, {date: day.date, rentalContractId: rentalContractLine} );
			};
			td.appendChild(sp);
			
			tr.append( td );
		}
		
		
		
		
		let tbody = document.querySelector('#tbody-rental-articles');
		tbody.appendChild( tr );
	}
	
	

	addArticle_monthly( art ) {
		// row
		let tr = document.createElement('tr');
		tr.className = 'article-line';
		
		// label
		let td_desc = document.createElement('td');
		td_desc.className = 'article-description';
		td_desc.innerText = art.shortDescription;
		tr.appendChild( td_desc );
		
		// convert dates to ymd
		let dates = [];
		for(let i=0; i < art.rentalContractLines.length; i++) {
			let rcl = art.rentalContractLines[i];
			
			let ymdStart = date2ymd( rcl.startTime );
			let ymdEnd  = rcl.endTime ? date2ymd( rcl.endTime ) : null;
			
			dates.push({ ymdStart: ymdStart, ymdEnd: ymdEnd, rentalContractLine: rcl });
		}
		
		
		// generate TD's for days
		for(let i=0; i < this.months.length; i++) {
			let month = this.months[i];
			let eom = end_of_month( month.start_month );
			
			let ymdStart = date2ymd( month.start_month );
			let ymdEnd = date2ymd( eom );
			
			
			let rentalContractLine = null;
			for(let i in dates) {
				if ( dates[i].ymdStart <= ymdEnd && ( dates[i].ymdEnd == null || dates[i].ymdEnd >= ymdStart ) )
					rentalContractLine = dates[i].rentalContractLine;
			}
			
			
			let td = document.createElement('td');
			
			if (rentalContractLine) {
				td.className = 'occupied';
			}
			else {
				td.className = 'open';
			}
			let sp = document.createElement('span');
			sp.innerHTML = '&nbsp;';
			sp.onclick = () => {
				this.showRentalInfo( art.articleId, {date: month.start_month, rentalContractId: rentalContractLine} );
			};
			td.appendChild(sp);
			
			tr.append( td );
		}
		
		
		
		
		let tbody = document.querySelector('#tbody-rental-articles');
		tbody.appendChild( tr );
	}

	
	showRentalInfo( articleId, opts ) {
		
		showRentalArticleInfo( articleId, opts );
	}
	
	viewMode() {
		if ( this.days.length < 65 ) {
			return 'daily';
		}
		else {
			return 'monthly';
		}
	}
	
	
	render() {
		this.colDates();
		
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('days', this.days);
		this.ezTpl.setVar('months', this.months);
		this.ezTpl.setVar('today', format_date(new Date()));
		
		if ( this.viewMode() == 'daily' ) {
			this.ezTpl.loadHtml( this.tplDaily );
		}
		else {
			this.ezTpl.loadHtml( this.tplMonthly );
		}
		
		this.ezTpl.render();
		
		
	}
	
	
}


