

import { showRentalArticleInfo } from '../../lib/RentalHelper.js';


loadCss('/static/app/widget/sales/css/rental-occupation.css');


export class RentalWeeklyView {

	tpl = `
		<table class="rental-weekly-view tbl-rentals">
			<thead>
				<tr class="week-list">
					<td></td>
					<td ez-forme="weeks" ez-item="w" colspan="7">
						{{_('week')}} {{w.week}} - {{w.year}}
					</td>
				</tr>
				<tr class="day-list-name">
					<td></td>
					<td ez-forme="days" ez-item="d" class="{{d.date == today ? 'td-today' : '' }}">
						{{ _('daynoshort.' + str2date(d.date).getDay()) }}
					</td>
				</tr>
				<tr class="day-list">
					<td></td>
					<td ez-forme="days" ez-item="d" class="{{d.date == today ? 'td-today' : '' }}">
						{{ parseInt(d.date.substring(8)) }}
					</td>
				</tr>
			</thead>
			<tbody id="tbody-rental-articles">
			</tbody>
		</table>
	`;
	
	
	weeksToShow = 4;
	
	container = null;
	
	ezTpl = null;
	
	days = null;
	weeks = null;
	
	lastSearchResult = null;
	
	
	
	init(e) {
		this.container = e;
		
	}
	
	
	getStart() {
		let d = document.querySelector('.container-settings input[name=d]').value;
		
		let date = str2date( d );
		if (!date)
			date = new Date();
		
		// 1 = monday
		while (date.getDay() != 1) {
			date.setDate( date.getDate() - 1 );
		}
		
		return format_date(date);
	}
	
	getEnd() {
		let s = this.getStart();
		let n = next_week( s, this.weeksToShow );
		
		let date = str2date(n);
		// 0 = sunday
		while (date.getDay() != 0) {
			date.setDate( date.getDate() + 1 );
		}
		
		
		return format_date(s);
	}
	
	
	colDates() {
		let s = this.getStart();
		
		this.weeks = [];
		this.days = [];
		
		for(let i=0; i < this.weeksToShow; i++) {
			let mom = moment(s, 'YYYY-MM-DD');
			
			this.weeks.push({
				year: mom.weekYear(),
				week: mom.week(),
				start_week: s
			});
			
			let startDay = s;
			for(let j=0; j < 7; j++) {
				this.days.push({
					date: startDay
				});
				
				startDay = next_day( startDay );
			}
			
			s = next_week( s, 1 );
		}
		
	}
	
	
	renderSearch( searchResult ) {
//		document.querySelector('#tbody-rental-articles').innerHTML = '';
		this.render();
		
		this.lastSearchResult = searchResult;
		
		let articles = searchResult.articles;
		
		for(let i=0; i < articles.length; i++) {
			let art = articles[i];
			this.addArticle( art );
		}
	}
	
	
	addArticle( art ) {
		// row
		let tr = document.createElement('tr');
		tr.className = 'article-line';
		
		// label
		let td_desc = document.createElement('td');
		td_desc.className = 'article-description';
		td_desc.innerText = art.shortDescription;
		tr.appendChild( td_desc );
		
		// convert dates to ymd
		let dates = [];
		for(let i=0; i < art.rentalContractLines.length; i++) {
			let rcl = art.rentalContractLines[i];
			
			let ymdStart = date2ymd( rcl.startTime );
			let ymdEnd  = rcl.endTime ? date2ymd( rcl.endTime ) : null;
			
			dates.push({ ymdStart: ymdStart, ymdEnd: ymdEnd, rentalContractLine: rcl });
		}
		
		
		// generate TD's for days
		for(let i=0; i < this.days.length; i++) {
			let day = this.days[i];
			
			let d = date2ymd( day.date );
			
			let rentalContractLine = null;
			for(let i in dates) {
				if ( d >= dates[i].ymdStart && ( dates[i].ymdEnd == null || dates[i].ymdEnd >= d ) )
					rentalContractLine = dates[i].rentalContractLine;
			}
			
			
			let td = document.createElement('td');
			
			if (rentalContractLine) {
				td.className = 'occupied';
			}
			else {
				td.className = 'open';
			}
			let sp = document.createElement('span');
			sp.innerHTML = '&nbsp;';
			sp.onclick = () => {
				this.showRentalInfo( art.articleId, {date: day.date, rentalContractId: rentalContractLine} );
			};
			td.appendChild(sp);
			
			tr.append( td );
		}
		
		
		
		
		let tbody = document.querySelector('#tbody-rental-articles');
		tbody.appendChild( tr );
	}
	
	

	
	showRentalInfo( articleId, opts ) {
		
		showRentalArticleInfo( articleId, opts );
	}
	
	
	render() {
		this.colDates();
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.setVar('days', this.days);
		this.ezTpl.setVar('weeks', this.weeks);
		this.ezTpl.setVar('today', format_date(new Date()));
		
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.render();
		
		
	}
	

	
	
}


