

import { SalesPlanHourWidget } from './SalesPlanHourWidget.js';
import { SalesPlanWeekWidget } from './SalesPlanWeekWidget.js';
import { SalesPlanMonthWidget } from './SalesPlanMonthWidget.js';
import { SalesRentalCheckoutPreviewWidget } from './SalesRentalCheckoutPreviewWidget.js';




export class SalesPlanWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
			</div>
			
			<h1>Sales planning</h1>
		</div>
		
		
			<!--
		<div id="frmPlan">
			<div>
				<ez-radio name="pt" label="Planning" value="">
					<option value="day">Dag</option>
					<option value="week">Week</option>
					<option value="month">Maand</option>
				</ez-radio>
			</div>
			
			<div class="clear"></div>
			
			<div class="input-day-plan">
				<ez-week name="week" value="" label="Week" autocreate="true"></ez-week>
			</div>
			
			<div class="input-week-plan input-month-plan">
				<ez-year name="y" value="" label="Jaar" start="-1" end="+2"></ez-year>
			</div>
			
		</div>
		
		<hr />
		-->
		
		<input type="text" class="q-sales" placeholder="Zoeken..." />
		
		<div id="checkout-preview"></div>
		
		<div id="plan"></div>
	`;
	
	
	container = null;
	ezTpl = null;
	
	currentWidget = null;
	
	checkoutPreviewWidget = null;
	
	lastSearchResponse = null;
	
	uid = null;
	articles = [];
	
	
	constructor() {
		if (getUrlParam('uid')) {
			this.uid = getUrlParam('uid');
			
			let session = getSession('co_'+this.uid);
			
			if (session != null) {
				this.articles = session.articles;
			}
			else {
				reportUserMessage( 'Session not found' );
				gotoRoute( '/sales/salesplan/' );
				return;
			}
		}
		else {
			this.uid = uuidv4();
			this.articles = getSession('salesplan_articles', []);
		}
	}
	
	init(e) {
		this._init(e);
		
	}
	
	_init(e) {
		this.container = e;
		this.render();
		
		let inps = $('#frmPlan input[name=s]');
		if (valid_date( inps.val() ) == false) {
			inps.val( format_date( this.startDate(), {dmy: true}) );
		}
		
		this.renderHourPlan( new Date() );
//		this.renderWeekPlan();
//		this.renderMonthPlan();
		
//		$('#frmPlan').find('input[name=s], select[name=e]').on('change dp.change', function() {
//			this.renderPlanning();
//		}.bind(this));
		
	}
	
	
	
	reset() {
		removeSession('salesplan_articles');
		reportUserMessage( 'Checkout reset' );
		gotoRoute( '/sales/salesplan/' );
	}
	
	checkout() {
		setSession('co_' + this.uid, {
			articles: this.articles
		});
		
		removeSession('salesplan_articles');
		
		gotoRoute( '/sales/salesplan/checkout/?uid='+this.uid );
	}
	
	searchArticles() {
		
		postUrl('/service/sales/plan.do', {
			a: 'search',
			q: document.querySelector('.q-sales').value
		}).then( async function(e) {
			let json = await e.json();
			console.log(json);
			
			this.lastSearchResponse = json;
			
			if (this.currentWidget) {
				this.currentWidget.setArticles( json.articles );
				
				this.currentWidget.render();
			}
		}.bind(this) );
		
	}
	
	
	
	startDate() {
		let c = $('#frmPlan');
		let sd = c.find('input[name=s]').val();
		
		// no date? => set today
		if (valid_date(sd))
			sd = format_date( str2date(sd) );
		else
			sd = format_date( new Date() );
		
		return sd;
	}
	
	endDate() {
		let sd = str2date( this.startDate() );
		sd.setHours(12);
		
		let end_moment = $('#frmPlan select[name=e]').val();
		
		if (end_moment == 'endWeek') {
			while ( sd.getDay() != 0 ) {
				sd = str2date( next_day( sd ) );
			}
		}
		else if (end_moment == 'endNextWeek') {
			sd = str2date( next_day( sd, 7 ) );
			while ( sd.getDay() != 0 ) {
				sd = str2date( next_day( sd ) );
			}
		}
		else if (end_moment == 'endMonth') {
			let dim = days_in_month( sd );
			
			let daysToGo = dim - sd.getDate();
			sd = str2date( next_day( sd, daysToGo ) );
		}
		else if (end_moment == 'endNextMonth') {
			sd = str2date( next_month( sd ) );
			
			let dim = days_in_month( sd );
			
			let daysToGo = dim - sd.getDate();
			sd = str2date( next_day( sd, daysToGo ) );
		}
		
		return format_date( sd );
	}
	
	
	loadArticles() {
		
	}
	
	
	
	renderHourPlan( date ) {
//		console.log('renderDayPlan');
		
		let weekYear = date2weekyear( date );
		let weekNo = date2week( date );
		
		let w = new SalesPlanHourWidget();
		w.init( document.querySelector('#plan') );
		
		w.setStartWeek( weekYear, weekNo );
		
		w.setCallbackSelectPeriod(function(p) {
			this.addArticle( p );
		}.bind(this));
		
		if ( this.lastSearchResponse ) {
			w.setArticles( this.lastSearchResponse.articles );
			w.render();
		}
		else {
			this.searchArticles();
		}
		
		
		this.currentWidget = w;
	}
	
	renderWeekPlan( weekDate ) {
		$('.input-day-plan').hide();
		$('.input-week-plan, .input-month-plan').show();
		
		let w = new SalesPlanWeekWidget();
		w.init( document.querySelector('#plan') );
		
//		let ey = document.querySelector('ez-year[name=y]');
		w.setYear( weekDate.getFullYear() );
		
		if (this.lastSearchResponse ) {
			w.setArticles( this.lastSearchResponse.articles );
			w.render();
		}
		else {
			this.searchArticles();
		}
		
		
		this.currentWidget = w;
	}
	
	renderMonthPlan() {
		$('.input-day-plan').hide();
		$('.input-week-plan, .input-month-plan').show();
		
		let w = new SalesPlanMonthWidget();
		w.init( document.querySelector('#plan') );
		
		let y = new Date().getFullYear();//document.querySelector('ez-year[name=y]');
		w.setYear( y );
		
		w.render();
		
		w.setCallbackMonthSelect(function(date) {
			this.renderWeekPlan(d);
		}.bind(this));
		
		
		w.setCallbackDaySelect(function(date) {
			this.renderHourPlan( date );
		}.bind(this));
		
		
		this.currentWidget = w;
	}
	
	renderCheckoutPreview() {
		if (this.checkoutPreviewWidget == null) {
			this.checkoutPreviewWidget = new SalesRentalCheckoutPreviewWidget();
			this.checkoutPreviewWidget.init( document.querySelector('#checkout-preview') );
			
			this.checkoutPreviewWidget.setCallbackRemoveArticle(function( article ) {
				let newList = [];
//				console.log(article.pos );
//				console.log('..?',this.articles);
				
				for(let i in this.articles) {
					if ( this.articles[i].pos == article.pos ) {
						continue;
					} else {
						newList.push( this.articles[i] );
					}
				}
				
				this.setArticles( newList );
			}.bind(this));
			
			this.checkoutPreviewWidget.setCallbackReset(function() {
				this.reset();
			}.bind(this));
			
			this.checkoutPreviewWidget.setCallbackCheckout(function() {
				this.checkout();
			}.bind(this));
		}
		
		this.checkoutPreviewWidget.setArticles( this.articles );
		this.checkoutPreviewWidget.render();
	}
	
	
	addArticle( art ) {
		let pos=1;
		for(let i in this.articles) {
			if ( this.articles[i].pos )
				pos = this.articles[i].pos + 1;
		}
		
		art.pos = pos;
		
		// check duplicate..
		let dup = false;
		// check slot-busines rules
		if (art.slotitemHour) {
			for(let i in this.articles) {
				if ( this.articles[i].article.articleId != art.article.articleId )
					continue;
				
				if (this.articles[i].day.ymd == art.day.ymd && this.articles[i].slotitemHour.startTime == art.slotitemHour.startTime) {
					dup = true;
					break;
				}
			}
		}
		else {
			
			// TODO: day-price support => check day
			
			// other
			for(let i in this.articles) {
				if ( this.articles[i].article.articleId == art.article.articleId ) {
					dup = true;
					break;
				}
			}
		}
		
		if (dup) {
			showToastMessage( 'Reeds toegevoegd' );
			return;
		}
		
		
		
		this.articles.push( art );
		
		setSession( 'salesplan_articles', this.articles );
		
		this.renderCheckoutPreview();
	}
	
	setArticles( articles ) {
		this.articles = articles;
		setSession( 'salesplan_articles', this.articles );
		this.renderCheckoutPreview();
	}
	
	
	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();
		
		this.renderCheckoutPreview();
		
//		this.searchArticles();
//		this.renderPlanning();
	}
	
}


