



export class SlotplanPricetypeListWidget {
	
	container = null;
	pricetypes = null;
	
	ezTpl = null;
	
	tpl = `
		<div class="page-header" style="background-color: unset;">
			<div class="toolbox">
				<a [onclick]="widget.addPricetype_Click" class="fa fa-plus"></a>
			</div>
			<h1 style="margin-bottom: 0; line-height: 25px;">Slotplan Prijstypes</h1>
		</div>
		
		<div class="clear"></div>
		
		<hr style="margin-top: 0;" />
		
		<div ez-if="pricetypes == null">
			Loading...
		</div>
		<div ez-if="pricetypes != null">
			<table class="table">
				<thead>
					<tr>
						<th></th>
						<th>Naam</th>
						<th style="width: 125px;">Actief</th>
						<th style="width: 150px;">Laatst bewerkt</th>
					</tr>
				</thead>
				<tbody  ez-for="pricetypes" ez-item="p" class="tbody-pricetypes">
					<tr [onclick]="widget.editPricetype" class="pointer" slotplan-pricetype-id="{{p.slotplanPricetypeId}}">
						<td style="width: 50px;" class="td-sort"><i class="fa fa-bars sort-handle"></i></td>
						<td>{{p.name}}</td>
						<td>{{p.active ? 'Ja' : 'Nee' }}</td>
						<td>{{ format_datetime(p.edited, {dmy: true}) }}</td>
					</tr>
				</tbody>
					
				<tbody ez-if="pricetypes.length == 0">
					<tr>
						<td colspan="4" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	`;
	
	
	editPricetype(evt, tr) {
		let target = $(evt.target);
		
		if (target.hasClass('td-sort') || target.closest('.td-sort').length > 0)
			return;
		
		let id = tr.getAttribute('slotplan-pricetype-id');
		
		gotoRoute( '/masterdata/sales/slotplan/pricetype/edit/?id='+id );
	}
	
	addPricetype_Click() {
		gotoRoute( '/masterdata/sales/slotplan/pricetype/edit/' );
	}


	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('pricetypes', this.pricetypes);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();

		$(this.container).find('.tbody-pricetypes').sortable({
			handle: '.sort-handle',
			update: function() {
				this.saveSort();
			}.bind(this)
		});
		
	}
	
	saveSort() {
		let ids = [];
		$('.tbody-pricetypes tr').each(function(index, node) {
			let id = $(node).attr('slotplan-pricetype-id');
			ids.push(id);
		});
		
		postUrl( '/service/sales/slot/pricetype.do', {
			a: 'updateSort',
			ids: ids.join(',')
		}).then( async function(e) {
				showToastMessage('Volgorde opgeslagen');
		}.bind(this));
	}
	
	
	loadPricetypes() {
		postUrl( '/service/sales/slot/pricetype.do')
		.then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.pricetypes = json.pricetypes;
			this.render();
			
		}.bind(this) );
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadPricetypes();
	}

}

