



export class UserActionEvents {
	
	
	constructor() {
		
		this.addActionButton();
	}
	
	
	addActionButton() {
		let container = document.querySelector('.user-edit-widget .action-box');
		if (!container)
			return;
		
		
		let s = document.createElement('span');
		
		let anch = document.createElement('a');
		anch.innerText = _('Mail link App');
		s.appendChild(anch);
		anch.onclick = () => {
			this.confirmSendLoginMail();
		};
		
		container.appendChild( s );
	}
	
	confirmSendLoginMail() {
		let frm = $('#frmUser');
		
		let userId = frm.find('input[name=user_id]').val();
		let email = frm.find('input[name=email]').val();
		
		
		let d = document.createElement('div');
		d.innerHTML = _('Send mail with link to sign on directly to the Report2base App')+' <input type="text" class="input-r2b-email" style="margin: 10px 0; width: 100%;" />';
		d.querySelector('input.input-r2b-email').value = email;
		
		showConfirmation(_('Send mail'), d, () => {
			this.sendAppLink( userId, document.querySelector('.input-r2b-email').value );
		});
	}
	
	async sendAppLink( userId, email ) {
		console.log(email);
		
		let r = await postJson('/service/r2b/appLoginLink.do', {
			userId: userId,
			email: email
		});
		
		let json = await r.json();
		
		
		if (json.success) {
			reportUserMessage(_('Mail sent'));
		}
		else {
			if (json.message) {
				reportUserMessage(_('Error sending mail') + ': ' + json.message );
			}
			else {
				reportUserMessage(_('Error sending mail') );
			}
		}
		
		
	}
	
	
}

