

import { UserListWidget } from '../masterdata/users/UserListWidget.js';



export class AppAuthRequestWidget {
	
	tpl = `
		<div class="app-auth-request-widget">
			<div class="page-header">
				<div class="toolbox">
					<a onclick="gotoRoute('/masterdata/')" class="fa fa-chevron-circle-left"></a>
				</div>
				<h1>{{_('Authentication requests')}}</h1>
			</div>
			
			<div class="action-box">
				<span><a [onclick]="widget.cleanup_Click">Remove all</a></span>
			</div>
			
			<div class="auth-request-container">
				<div class="auth-requests">
					<div ez-for="requests" ez-item="r">
						<div class="request-item" [onclick]="widget.request_Click" [request]="r">
							<div class="request-info">
								<b>#{{r.appAuthRequestId}}</b>
								{{format_datetime(r.created)}} - {{r.inputName}}
							</div>
							<div class="status">
								{{r.status}}
							</div>
						</div>
					</div>
				
					<div ez-if="requests == null">
						{{_('Loading...')}}
					</div>
					<div ez-if="requests != null && requests.length == 0" class="no-results-found">
						{{_('No results found')}}
					</div>
					
				</div>
				
				<div class="auth-request-info"></div>
				
			</div>
		</div>
	`;
	
	
	tplRequest = `
		<div class="action-box" ez-if="r.status == 'open'">
			<span><a href="javascript:void(0);" [onclick]="widget.acceptRequest_Click" [request]="r">{{_('Accept')}}</a></span>
			
			<span><a href="javascript:void(0);" [onclick]="widget.rejectRequest_Click" [request]="r">{{_('Reject')}}</a></span>
		</div>
		
		<hr ez-if="r.status == 'open'" />
		
		<input type="hidden" name="selectedAppAuthRequest" [appAuthRequest]="r" />
		
		<div class="item">
			<b>#{{r.appAuthRequestId}}</b>
		</div>
		
		<div class="item">
			<label>{{_('Status')}}</label>
			<span>{{r.status}}</span>
		</div>
		
		<div class="item" ez-if="r.logInfo != null && r.logInfo != ''">
			<label>{{_('Log info')}}</label>
			<span>{{r.logInfo}}</span>
		</div>

		<div class="item" ez-if="r.userId != null">
			<label>{{_('Linked to user')}}</label>
			<span>
				{{r.username != null ? r.username : r.userId}}
			</span>
		</div>

		<div class="item">
			<label>{{_('Time-moment')}}</label>
			<span>{{format_datetime(r.created, {dmy:true})}}</span>
		</div>
		
		<div class="item">
			<label>{{_('Alias')}}</label>
			<span>{{r.inputName}}</span>
		</div>
		
		<div class="item">
			<label>{{_('IP address')}}</label>
			<span>{{r.ip}}</span>
		</div>
		
		<div class="item">
			<label>{{_('User agent')}}</label>
			<span>{{r.userAgent}}</span>
		</div>
	`;
	
	
	
	container = null;
	
	requests = null;
	
	selectedAppAuthRequestId = null;
	
	lastUpdateCheck = null;
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadRequests();
		
		
		$('#btn-auth-request').css('color', '');
		$('#btn-auth-request').data('color-set', false);
	}
	
	async loadRequests() {
		let r = await postJson('/service/r2b/authrequests.do', {
			a: 'listAuths'
		});
		
		let json = await r.json();
		
		this.requests = json.requests;
		
		this.render();
		
		if (this.selectedAppAuthRequestId != null) {}
		this.selectRequest( this.selectedAppAuthRequestId );
	}
	
	cleanup_Click() {
		// TODO: ask confirmation?.. not that important anyway..
		
		showConfirmation(_('Delete all'), _('Are you sure to delete all requests?'), async () => {
			let r = await postJson('/service/r2b/authrequests.do', {
				a: 'truncateRequests'
			});
			
			this.loadRequests();
		});
	}
	
	
	request_Click( evt, obj ) {
		let r = obj.request;
		
//		console.log('r', r);
		
		this.showAuthRequest( r );
	}
	
	selectRequest(appAuthRequestId) {
		for(let i in this.requests) {
			if ( this.requests[i].appAuthRequestId == appAuthRequestId ) {
				this.showAuthRequest( this.requests[i] );
				break;
			}
		}
	}
	
	showAuthRequest( authRequest ) {
		let tpl = new EzTemplate('.auth-request-info');
		tpl.loadHtml( this.tplRequest );
		tpl.setObject('widget', this);
		tpl.setVar('r', authRequest);
		tpl.render();
	}
	
	async rejectRequest_Click(evt, obj) {
		let r = await postJson('/service/r2b/authrequests.do', {
			a: 'rejectRequest',
			id: obj.request.appAuthRequestId
		});
		
		let json = await r.json();
		
		this.loadRequests();
	}
	
	acceptRequest_Click(evt, obj) {
		
		let ulw = new UserListWidget();
		ulw.showPopup();
		ulw.setCallbackUserSelected( (user) => {
			this.acceptRequest( obj.request, user );
		});
	}
	
	async acceptRequest( appAuthRequest, user ) {
		let r = await postJson('/service/r2b/authrequests.do', {
			a: 'acceptRequest',
			id: appAuthRequest.appAuthRequestId,
			selectedUserId: user.userId
		});
		
		let json = await r.json();
		
		this.selectedAppAuthRequestId = appAuthRequest.appAuthRequestId;
		
		this.loadRequests();
	}
	
	
	async checkUpdates() {
		let now = new Date().getTime();
		
		// checkUpdates called last 10 sec? => skip
		if (this.lastUpdateCheck != null && now - this.lastUpdateCheck < 10000)
			return;
		
		this.lastUpdateCheck = now;
		
		let lastRequest = this.requests.length > 0 ? this.requests[0] : null;
		let r = await postJson('/service/r2b/authrequests.do', {
			a: 'listAuths',
			lastAppAuthRequestId: lastRequest != null ? lastRequest.appAuthRequestId : null
		});

		let json = await r.json();
		if (json.requests.length == 0) {
			return;
		}
		
		if (json.requests.length > 0) {
			let inp = document.querySelector('input[name=selectedAppAuthRequest]')
			if (inp && inp.appAuthRequest) {
				this.selectedAppAuthRequestId = inp.appAuthRequest.appAuthRequestId;
			}
			
			this.loadRequests();
			
			return;
		}
		

	}
	
	
	
	render() {
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('requests', this.requests);
		
		eztpl.render();
		
		document.querySelector('.app-auth-request-widget').appAuthRequestWidget = this;
	}
	
	
}


