


export class PermissionsWidget {
	
	
	tpl = `
		<div class="action-box">
			<span>
				<a class="btn-link-user-group" href="javascript:void(0);" [onclick]="widget.addPermissionRecord">Gebruiker/groep toevoegen</a>
			</span>
		</div>
		
		<br/>

		<table class="table">
			<thead>
				<tr>
					<th>Gebruiker</th>
					<th>Permissies</th>
					<th></th>
				</tr>
			</thead>
			
			<tbody class="tbody-permissions">
				<tr class="no-results-found">
					<td colspan="100%">
						{{_('No results found')}}
					</td>
				</tr>
			</tbody>
			
		</table>
	`;
	
	
	container = null;
	eztpl = null;
	
	input_counter = 0;
	
	writable = true;
	
	
	setWritable(bln) { this.writable = bln; }
	
	
	
	init(e) {
		this.container = e;
	}
	
	renderTab() {
		let tabBtn = document.createElement('li');
		tabBtn.className = 'nav-item';
		tabBtn.setAttribute('role', 'presentation');
		
		let btn = document.createElement('button');
		btn.className = 'nav-link';
		btn.setAttribute('id', 'perms-tab');
		btn.setAttribute('data-bs-toggle', 'tab');
		btn.setAttribute('data-bs-target', '#perms');
		btn.setAttribute('type', 'button');
		btn.setAttribute('role', 'tab');
		btn.setAttribute('aria-controls', 'perms');
		btn.setAttribute('aria-selected', 'false');
		btn.innerText = _('Permissions');
		tabBtn.appendChild( btn );
		$(this.container).find('.nav-tabs').append( tabBtn );
		
		
		let tabContainer = document.createElement('div');
		tabContainer.className = 'tab-pane fade permissions-edit-container';
		tabContainer.setAttribute('id', 'perms');
		tabContainer.setAttribute('role', 'tabpanel');
		tabContainer.setAttribute('aria-labelledby', 'perms-tab');
		
		$(this.container).find('.tab-content').append( tabContainer );
		
		
		this.eztpl = new EzTemplate( tabContainer );
		this.eztpl.loadHtml( this.tpl );
		this.eztpl.setObject('widget', this);
		this.eztpl.render();

	}
	
	render() {
		this.eztpl = new EzTemplate( this.container );
		this.eztpl.loadHtml( this.tpl );
		this.eztpl.setObject('widget', this);
		this.eztpl.render();
	}


	
	getPermissions() {
		let list = [];
		
		let trs = $(this.container).find('.tr-user-permission');
		
		trs.each((index, node) => {
			
			
			let uid = $(node).find('.user-selection .widget-value').val();
			if (uid == '') return;
			
			let accessMethod = $(node).find('.perm_access:checked').val();
			if (accessMethod == '') return;
			
			
			let up = {};
			up.refUserGroupId = uid;
			up.accessMethod = accessMethod;
			
			list.push( up );
		});
		
		return list;
	}


	addPermissionRecord( ) {
		this.createPermissionRecord();
	}

	setPermissions( perms ) {
		
		for(let i=0; i < perms.length; i++) {
			this.createPermissionRecord( perms[i] );
		}
		
	}

	createPermissionRecord( opts ) {
		opts = opts ? opts : {};
		
		let no = ++this.input_counter;
		
		let tr = document.createElement('tr');
		tr.className = 'tr-user-permission';
		
		let tduser        = document.createElement('td');
		
		let tdpermissions = document.createElement('td');
		tdpermissions.className = 'td-permissions';
		
		
		let inp_read = document.createElement('input');
		inp_read.type = 'radio';
		inp_read.name = 'perm_access_'+no;
		inp_read.className = 'perm_access';
		inp_read.value = 'read';
//		inp_read.checked = true;
		if (this.writable == false)
			inp_read.setAttribute('disabled', 'disabled');
		
		let lbl_read = document.createElement('label');
		lbl_read.className = 'perm-read';
		lbl_read.append( inp_read );
		lbl_read.append( ' lezen ' );
		
		
		
		
		let inp_write = document.createElement('input');
		inp_write.type = 'radio';
		inp_write.value = 'write';
		inp_write.name = 'perm_access_'+no;
		inp_write.className = 'perm_access';
		inp_write.checked = true;
		if (this.writable == false)
			inp_write.setAttribute('disabled', 'disabled');
		
		let lbl_write = document.createElement('label');
		lbl_write.className = 'perm-write';
		lbl_write.append(inp_write);
		lbl_write.append( ' schrijven ');
		
		tdpermissions.append( lbl_write );
		tdpermissions.append( '  ' );
		tdpermissions.append( lbl_read );
		
		if (opts && opts.accessMethod == 'read') {
			inp_read.checked = true;
			inp_write.checked = false;
		}
		if (opts && opts.accessMethod == 'write') {
			inp_read.checked = false;
			inp_write.checked = true;
		}
		
		
		// del
		let tdactions     = document.createElement('td');
		tdactions.className = 'actions';
		
		if (this.writable) {
			let a_del = document.createElement('a');
			a_del.className = 'fa fa-trash';
			a_del.href = 'javascript:void(0);';
			a_del.onclick = function() {
				$(this).closest('tr').remove();
			};
			tdactions.append( a_del );
		}
		
		
		
		tr.append( tduser );
		tr.append( tdpermissions );
		tr.append( tdactions );
		
//		let tbody_permissions = document.getElementById( 'tbody-permissions' );
//		console.log('tbody_per', tbody_permissions);
		$(this.container).find('.tbody-permissions' ).append( tr );
		
		if (this.writable) {
			let d = document.createElement('div');
			d.className = 'ez-table-container user-selection';
			tduser.append(d);
			
			
			let eztbl = new EzTableSelector( d );
			eztbl.setName( 'perm_ug_'+no );
			
			if (opts && opts.refUserGroupId ) {
				eztbl.setValueText( opts.refUserGroupId, opts.textValue );
			}
			eztbl.setUrl( appUrl('/service/users.do?a=listUserGroups') );
			eztbl.init();
		}
		else {
			let span_username = document.createElement('span');
			span_username.innerText = opts.textValue;
			tduser.append( span_username );
		}
	}
	
}

