


export class WorkReportV1 {
	
	
	
	tpl = `
		<div class="work-reportv1">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.export_Click" class="fa fa-file-excel"></a>
				</div>
				<h1>{{_('Work report')}}</h1>
			</div>
			
			<div class="frm-work-reportv1">
				<div>
					<label>Status</label>
					<label style="width: auto;"><input type="checkbox" [checked]="rs.open"       name="rsOpen" /> {{_('reportStatus.open')}}</label>
					<label style="width: auto;"><input type="checkbox" [checked]="rs.inprogress" name="rsInprogress" /> {{_('reportStatus.inprogress')}}</label>
					<label style="width: auto;"><input type="checkbox" [checked]="rs.cancelled" name="rsCancelled" /> {{_('reportStatus.cancelled')}}</label>
					<label style="width: auto;"><input type="checkbox" [checked]="rs.processed"  name="rsProcessed" /> {{_('reportStatus.processed')}}</label>
				</div>
			
				<ez-customer name="cid" [value]="cid" label="{{_('Relation')}}"></ez-customer>
				
				<div class="period">
					<ez-date name="s" [value]="s" label="{{_('Start')}}"></ez-date>
					<ez-date name="e" [value]="e" label="{{_('End')}}"></ez-date>
				</div>
				
				<div style="margin-bottom: 5px;">
					<ez-select name="ty" label="{{_('Type')}}" [value]="ty">
						<option value="">{{_('Make your choice')}}</option>
						<option value="hour">{{_('Hour')}}</option>
						<option value="number">{{_('Amount')}}</option>
						<option value="amount">{{_('Amount money')}}</option>
					</ez-select>
				</div>
				
				<div style="margin-top: 5px;">
					<a style="color: #00f;" [onclick]="widget.reset_Click">{{_('Reset')}} &gt;</a>
				</div>
			</div>
			
			<hr/>
			
			<div class="report" ez-subtemplate="work-report">
				<div ez-if="loading == true">
					Loading...
				</div>
				
				<div ez-if="loading == false" class="selected-type-{{ty}}">
					<table class="table">
						<thead>
							<tr>
								<th style="width: 40px;">
									<input type="checkbox" class="toggle-all" checked=checked style="width: auto;" />
								</th>
								<th>{{_('Type')}}</th>
								<th>{{_('Relation')}}</th>
								<th>{{_('Description')}}</th>
								<th>{{_('Start')}}</th>
								<th>{{_('End')}}</th>
								<th class="col-hours">{{_('Hours')}}</th>
								<th class="col-numbers">{{_('Numbers')}}</th>
								<th class="col-price">{{_('Price')}}</th>
								<th>{{_('Report status')}}</th>
							</tr>
						</thead>
						<tbody ez-for="lines" ez-item="l">
							<tr [line]="l" [onclick]="widget.line_Click" class="pointer">
								<td class="td-toggle-entry">
									<input type="checkbox" class="toggle-entry" [line]="l" checked=checked />
								</td>
								<td>{{_('widgetType.description.'+l.widget_type)}}</td>
								<td>{{ifnull(l.customer_name, '')}}</td>
								<td>{{l.description}}</td>
								
								<td>{{format_datetime_minutes( l.entry_date, {dmy: true, showZero: false}) }}</td>
								<td>
									{{format_datetime_minutes( l.end_time, {dmy: true, showZero: false}) }}
								</td>
								<td class="col-hours">{{ifnull(l.duration, '')}}</td>
								<td class="col-numbers">
									{{ifempty(l.number, '')}}
								</td>
								<td class="col-price">
									{{ l.price ? format_price(l.price, true) : '' }}
								</td>
								<td id="status-{{l.widget_type}}-{{l.ref_id}}">
									{{_('reportStatus.'+l.status)}}
								</td>
							</tr>
						</tbody>
						<tbody ez-if="lines.length == 0">
							<tr class="no-results-found">
								<td colspan="100%">{{_('No results found')}}</td>
							</tr>
						</tbody>
						<tfoot>
							<tr>
								<td></td>
								<td></td>
								<td></td>
								<td></td>
								<td></td>
								<td></td>
								
								<td class="col-hours">{{totalDuration}}</td>
								<td class="col-numbers">{{totalNumbers}}</td>
								
								<td class="col-price">{{format_price(totalPrice, true)}}</td>
								
								<td></td>
							</tr>
						</tfoot>
					</table>
					
					{{_('Update status')}}:
					<select name="us">
						<option value="">{{_('Make your choice')}}</option>
						<option value="open">{{_('reportStatus.open')}}</option>
						<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
						<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
						<option value="processed">{{_('reportStatus.processed')}}</option>
					</select>
					<button [onclick]="widget.updateStatus_Click">{{_('Update')}}</button>
				</div>
			</div>
			
			<br/>
		</div>
	`;
	
	
	container = null;
	lines = [];
	loading = true;
	
	rs = {
		open: true,
		inprogress: true,
		cancelled: true,
		processed: true
	}
	
	
	init(e) {
		this.container = e;
		
		let urlParams = getUrlParams();
		if (typeof urlParams['rsOpen'] != 'undefined' && urlParams['rsOpen'] == '0')
			this.rs.open = false;
		if (typeof urlParams['rsInprogress'] != 'undefined' && urlParams['rsInprogress'] == '0')
			this.rs.inprogress = false;
		if (typeof urlParams['rsProcessed'] != 'undefined' && urlParams['rsProcessed'] == '0')
			this.rs.processed = false;
		
		
		this.render();
	}
	
	render() {
		let eztpl = new EzTemplate( this.container );
		eztpl.setObject('widget', this);
		eztpl.setVar('loading', this.loading);
		
		
		let params = getUrlParams();
		
		eztpl.setVar('cid', params['cid'] ?? '');
		
		if ( typeof params['s'] == 'undefined' ) {
			// default to 1st of prev month
			eztpl.setVar('s', previous_month(start_of_month(new Date())));
		} else {
			eztpl.setVar('s', params['s']);
		}

		if ( typeof params['e'] == 'undefined' ) {
			eztpl.setVar('e', '');
		} else {
			eztpl.setVar('e', params['e']);
		}
		
		
		
		eztpl.setVar('rs',  this.rs);
		
		eztpl.setVar('ty',  getUrlParam('ty') ?? '');
		
		eztpl.loadHtml( this.tpl );
		eztpl.render();
		
		$('.frm-work-reportv1').find('input, select, ez-customer').on('change dp.change', () => {
			if (this.loading)
				return;
			this.updateReport();
		});
		
		
		this.loadReport();
	}
	
	
	async loadReport()  {
		let d = {};
		d.customerId   = $('input[name=cid]').val();
		d.startDate    = $('input[name=s]').val();
		d.endDate      = $('input[name=e]').val();
		d.rsOpen       = $('input[name=rsOpen]').prop('checked') ? 1 : 0;
		d.rsInprogress = $('input[name=rsInprogress]').prop('checked') ? 1 : 0;
		d.rsCancelled  = $('input[name=rsCancelled]').prop('checked') ? 1 : 0;
		d.rsProcessed  = $('input[name=rsProcessed]').prop('checked') ? 1 : 0;
		d.widgetType   = $('select[name=ty]').val();
		
		showLoadingForm('.work-reportv1');
		
		let r = await postUrl('/service/reporting/workHourReport.do', d);
		let json = await r.json();
		
		
		if (json.customerId && document.querySelector('input[name=cid]').value == json.customerId) {
			document.querySelector('ez-customer[name=cid] .cst-selector-text').innerText = json.customerName;
		}
		
		hideLoadingForm('.work-reportv1');
		
		this.loading = false;
		
		let eztpl = document.querySelector('div[ez-subtemplate=work-report]').eztemplate;
		eztpl.setObject('widget', this);
		eztpl.setVar( 'lines', json.lines );
		eztpl.setVar( 'totalPrice', json.totalPrice );
		eztpl.setVar( 'totalDuration', json.totalDuration );
		eztpl.setVar( 'totalNumbers', json.totalNumbers );
		eztpl.setVar( 'loading', this.loading );
		eztpl.setVar( 'ty', $('select[name=ty]').val() );
		eztpl.render();
		
		
		// handle toggle events
		$('.work-reportv1 .toggle-all').on('change', function() {
			if (this.checked) {
				$('.toggle-entry').prop('checked', true);
			}
			else {
				$('.toggle-entry').prop('checked', false);
			}
		});
		$('.work-reportv1 .toggle-entry').on('change', function() {
			
			let cnt_all = $('.work-reportv1 .toggle-entry').length;
			let cnt_checked= $('.work-reportv1 .toggle-entry:checked').length;
			
			if (cnt_all == cnt_checked) {
				$('.work-reportv1 .toggle-all').prop('checked', true);
			}
			else {
				$('.work-reportv1 .toggle-all').prop('checked', false);
			}
			
		});
	}
	
	line_Click( evt, obj ) {
		if ($(evt.target).hasClass('.toggle-entry') || $(evt.target).closest('.td-toggle-entry').length > 0)
			return;
		
		let line = obj.line;
		
		if (line.widget_type == 'WorkHour') {
			gotoRoute('/hour/edit/?id=' + line.ref_id);
		}
		else if (line.work_order_id) {
			gotoRoute('/work/edit/?id=' + line.work_order_id);
		}
		else {
			console.log('Unknown line type', line);
		}
	}
	
	buildFormParams() {
		let params = [];
		
		let cid = $('input[name=cid]').val();
		if (cid != '')
			params.push('cid='+cid);
		
		let s = $('input[name=s]').val();
		params.push('s='+s);
		let e = $('input[name=e]').val();
		params.push('e='+e);
		
		if ($('input[name=rsOpen]').prop('checked'))
			params.push('rsOpen=1');
		else
			params.push('rsOpen=0');
		if ($('input[name=rsInprogress]').prop('checked'))
			params.push('rsInprogress=1');
		else
			params.push('rsInprogress=0');
		if ($('input[name=rsCancelled]').prop('checked'))
			params.push('rsCancelled=1');
		else
			params.push('rsCancelled=0');
		if ($('input[name=rsProcessed]').prop('checked'))
			params.push('rsProcessed=1');
		else
			params.push('rsProcessed=0');
		
		let ty = $('select[name=ty]').val();
		if (ty != '')
			params.push('ty='+ty);
		
		return params;
	}
	
	updateReport() {
		// update url
		let l = window.location.toString();
		if (l.indexOf('?') != -1) {
			l = l.substring(0, l.indexOf('?'));
		}
		
		let params = this.buildFormParams();
		if (params.length > 0)
			l += '?' + params.join('&');
		window.history.replaceState({}, null, l);
		
		
		// load report
		this.loadReport();
	}
	
	
	async updateStatus_Click() {
		
		// check status
		let s = document.querySelector('.work-reportv1 select[name=us]').value;
		if (s == '') {
			showAlert(_('Error'), _('No status selected'));
			return;
		}
		
		// check records
		let entries = $('.toggle-entry:checked');
		if (entries.length == 0) {
			showAlert(_('Error'), _('No records selected'));
			return;
		}
		
		
		let recs = [];
		entries.each((i, n) => {
			let line = n.line;
			recs.push({
				ref_id: line.ref_id,
				widget_type: line.widget_type
			});
		});
		
		showLoadingForm('.work-reportv1');
		
		let r = await postJson('/service/reporting/workHourReport.do', {
			a: 'update',
			newStatus: s,
			lines: recs
		});
		
		let json = await r.json();
		
		for(let i in json.updatedStatus) {
			$('#status-' + i).text( _('reportStatus.'+json.updatedStatus[i]) );
		}
		
		
		hideLoadingForm('.work-reportv1');
	}
	
	
	export_Click() {
		let params = this.buildFormParams();
		params.push('a=export');

		window.location = appUrl('/service/reporting/workHourReport.do?' + params.join('&'));
	}
	
	
	
	reset_Click() {
		gotoRoute('/reporting/');
	}
	
	
}

