

export class RegisterAppWidget {
	
	tpl = `
	
		<div style="width: 600px; margin: 10% auto 0; text-align: center;">
			<div style="text-align: center;"><img src="/static/img/r2b-logo.png" /></div>
			
			
			<div style="display: flex; margin: 25px auto 0; width: 400px;">
				<label>Administratie naam * &nbsp;</label>
				<div>
					<div><input type="text" name="relayAlias" placeholder="" /></div>
					<div id="password-container" style="display: none;"><input type="password" name="relayPassword" placeholder="{{_('Password')}}" /></div>
				</div>
				
				<div>
					<button [onclick]="widget.register_Click">Verder &gt;</button>
				</div>
				
				<img id="loading-indicator" [src]="url_ajaxLoader" style="margin-left: 5px; width: 20px; height: 20px; visibility: hidden;" />
			</div>
			
			<div id="error-message" style="color: #f00; margin-top: 25px; font-style: italic; "></div>
			
			
			<div style="margin-top: 25px; font-style: italic;">
				* Deze naam wordt gebruikt in de mobiele app om uw omgeving op te zoeken
			</div>
		</div>
	`;
	
	container = null;
	
	passwordBoxShown = false;
	
	init(e) {
		this.container = e;
		
		this.checkConfigured();
		
		this.render();
	}
	
	showLoading() {
		$('input[name=relayAlias], button').attr('disabled', 'disabled');
		$('#loading-indicator').css('visibility', 'unset');
	}
	removeLoading() {
		$('input[name=relayAlias], button').removeAttr('disabled');
		$('#loading-indicator').css('visibility', 'hidden');
	}
	
	
	async checkConfigured() {
		
		let r = await postJson('/service/r2b/relaysettings.do', {
			a: 'relayConfigured'
		});
		
		let json = await r.json();
		
		if (json && json.configured) {
			window.location = appUrl('/');
		}
	}
	
	
	async register_Click() {
		this.showLoading();
		
		
		let r = null;
		if (this.passwordBoxShown == false) {
			r = await postJson('/service/r2b/relaysettings.do', {
				a: 'registerApp',
				relayAlias: $('input[name=relayAlias]').val()
			});
		}
		else {
			r = await postJson('/service/r2b/relaysettings.do', {
				a: 'authApp',
				relayAlias: $('input[name=relayAlias]').val(),
				password: $('input[name=relayPassword]').val()
			});
		}
		
		let json = await r.json();
		
		if (json.success) {
			window.location = appUrl('/');
		}
		else {
			if (json.error_code == 'already_used') {
				$('#error-message').html( 'Naam reeds ingebruik, <a href="javascript:void(0);" style="color: #00f;" id="anchor_reset_ww">wachtwoord invoeren</a> ?' );
				
				$('#anchor_reset_ww').on('click', () => {
					this.showPasswordBox();
					
					$('#error-message').html('');
				});
			}
			else {
				$('#error-message').text( json.message );
			}
		}
		
		this.removeLoading();
	}
	
	showPasswordBox() {
		$('#password-container').show();
		$('input[name=relayPassword]').focus();
		
		this.passwordBoxShown = true;
	}
	hidePasswordBox() {
		$('#password-container').hide();
		
		this.passwordBoxShown = false;
	}
	
	
	render() {
		
		let eztpl = new EzTemplate( '.app-container' );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('url_ajaxLoader', appUrl('/static/img/ajax-loader-small.gif'));
		
		eztpl.render();
		
		$('body > nav').hide();
		
		
		$('input[name=relayAlias]').on('input change', (evt) => {
			let t = evt.target;
			t.value = t.value.replace(/[^a-zA-Z0-9]/g, '');
			
			this.hidePasswordBox();
		});
		
		$('input[name=relayAlias]').focus();
	}
	
	
}

