


export class RelaySettingsWidget {
	
	tpl = `
		<style type="text/css">
			input[name=relayLocation]
			, input[name=rtobAppUrl]
			, input[name=rtobAdminUrl] { width: 350px; }
		</style>
		<div class="page-header">
			<div class="toolbox">
				<a onclick="gotoRoute('/masterdata/')" class="fa fa-chevron-circle-left"></a>
				<a [onclick]="widget.save_Click" class="fa fa-save"></a>
			</div>
			<h1>Report2Base {{_('Settings')}}</h1>
		</div>

		<div class="error-container"></div>		
		
		<form>
			<ez-string label="Report2Base code" [value]="settings.rtobRelayName"></ez-string>
			
			<span ez-if="relayRoutingEditable">
				<ez-checkbox label="Relay active" 
								name="rtobApiActive"
								[onchange]="widget.relayActive_Change" 
								[checked]="settings.rtobApiActive"></ez-checkbox>
			</span>
			
			<ez-radio label="Authentication" name="rtobAuthenticationMethod" [value]="settings.rtobAuthenticationMethod">
				<option value="login_request">Login + request</option>
				<option value="login">Login only</option>
			</ez-radio>
						
			
			<div id="relay-settings">
				<ez-text label="Administratie naam" name="rtobRelayAlias" [value]="settings.rtobRelayAlias"></ez-text>
				
				<div style="display: flex;">
					<ez-password label="Wachtwoord" name="rtobPassword" autocomplete="current-password" [value]="settings.rtobPassword"></ez-password>
					<div style="padding: 3px 0 0 5px;">
						<a class="fa fa-eye" [onclick]="widget.showPassword"></a>
					</div>
				</div>
				
				<span ez-if="relayRoutingEditable == true">
					<ez-text label="Url relay server *" name="relayLocation" [value]="settings.locationUrl"></ez-text>
					
					<ez-text label="Url admin" name="rtobAdminUrl" [value]="settings.rtobAdminUrl"></ez-text>
					
					<ez-text label="Url app *" name="rtobAppUrl" [value]="settings.rtobAppUrl"></ez-text>
				
					<div style="margin-top: 20px; font-style: italic; font-size: 10px;">
						* Indien u Report2Base op een eigen server installeert kunt u hier de url invoeren, zodat 
						de mobiele App direct verbinding kan maken. Zit u achter een firewall? Dan is het geadviseerd deze op de standaard instellingen te laten staan.
					</div>
				</span>
			</div>
		</form>
		
	`;
	
	
	container = null;
	settings = {};
	
	relayRoutingEditable = false;
	
	init(e) {
		
		this.container = e;
		
		this.loadSettings();
	}
	
	
	async loadSettings() {
		let r = await postUrl('/service/r2b/relaysettings.do', { a: 'settings' });
		
		let json = await r.json();
		this.settings = json;
		this.relayRoutingEditable = json.relayRoutingEditable;
		
		document.querySelector('.titlebar-title-suffix').innerText = ' - ' + json.rtobRelayAlias;
		
		this.render();
	}
	
	showPassword() {
		if ($('input[name=rtobPassword]').attr('type') == 'text') {
			$('input[name=rtobPassword]').attr('type', 'password');
		}
		else {
			$('input[name=rtobPassword]').attr('type', 'text');
		}
	}
	
	
	
	async save_Click() {
		
		let data = {};
		data.a = 'saveSettings';
		
		if ( this.relayRoutingEditable == true ) {
			data.apiActive  = $('#cb_rtobApiActive').get(0).checked ? 1 : 0;
			data.relayLocation  = $('input[name=relayLocation]').val();
			data.rtobAdminUrl  = $('input[name=rtobAdminUrl]').val();
			data.rtobAppUrl  = $('input[name=rtobAppUrl]').val();
		}
		
		data.relayAlias = $('input[name=rtobRelayAlias]').val();
		data.password   = $('input[name=rtobPassword]').val();
		data.authenticationMethod  = $('[name=rtobAuthenticationMethod]:checked').val();
		
		let r = await postUrl('/service/r2b/relaysettings.do', data);
		
		let json = await r.json();
		
		if (json.success) {
			reportUserMessage( _('Changes saved') );
			gotoRoute('/masterdata/relay/');
		}
		else {
			let ul = $('<ul class="error-list" />');
			
			let li = $('<li />');
			li.text( json.message );
			ul.append(li);
			
			$('.error-container').empty();
			$('.error-container').append(ul);
		}
		
	}
	
	relayActive_Change() {
		
		if (this.relayRoutingEditable == false)
			return;
		
		let active = $('#cb_rtobApiActive').get(0).checked;
		
		if (active) {
			$('#relay-settings').show();
		}
		else {
			$('#relay-settings').hide();
		}
	}
	
	
	render() {
		
		let ez = new EzTemplate( this.container );
		ez.loadHtml(this.tpl);
		ez.setObject('widget', this);
//		ez.setVar('hosted', toolboxConfig.hosted);
		ez.setVar('settings', this.settings);
		ez.setVar('relayRoutingEditable', this.relayRoutingEditable);
		ez.render();
		
		this.relayActive_Change();
		
		
		$('input[name=rtobRelayAlias]').on('input change', (evt) => {
			let t = evt.target;
			t.value = t.value.replace(/[^a-zA-Z0-9]/g, '');
			
//			this.hidePasswordBox();
		});
	}
	
	
}


