
import { ActivityPopup } from '../masterdata/activity/ActivityPopup.js';
import { appConfig } from '../../service/AppConfig.js';


export class RtobDashboardWidget {
	
	tpl = `
	<div class="rtob-dashboard-widget">
		<div class="page-header">
			<h1>Dashboard</h1>
		</div>
		
		<div class="row">
			<div class="dashboard-widget col-md-6 col-sm-12" ez-subtemplate="subworkorders">
				<div class="title" title="Laatste 50">{{_('Work orders')}}</div>
				<div class="content">
					<span ez-if="typeof workOrders == 'undefined'">Loading...</span>
					<span ez-if="typeof workOrders != 'undefined'">
						<div class="no-results" ez-if="workOrders.length == 0">Geen resultaten gevonden</div>
						<div ez-if="workOrders.length > 0">
							<table class="table">
								<thead>
									<tr>
										<th style="width: 25px;">#</th>
										<th>Omschrijving</th>
										<th style="width: 140px;">Tijdstip</th>
										<th style="width: 140px;">{{_('Edited')}}</th>
									</tr>
								</thead>
								
								<tbody ez-for="workOrders" ez-item="wo">
									<tr class="pointer" data-work-order-id="{{wo.workOrderId}}" [onclick]="widget.workOrder_Click">
										<td>{{ wo.workOrderId }}</td>
										<td>
											<div>{{ ifnull(wo.customerName, '')  }}</div>
											<div>{{ wo.description  }}</div>
										</td>
										<td>{{ format_datetime_minutes(wo.orderDate, {showZero: false}) }}</td>
										<td>{{ format_datetime_minutes(wo.edited) }}</td>
									</tr>
								</tbody>
							</table>
						</div>
					</span>
				</div>
			</div>
			
			<div class="dashboard-widget col-md-6 col-sm-12" ez-subtemplate="subhours">
				<div class="title" title="Laatste 50">{{_('Hours')}}</div>
				<div class="content">
					<span ez-if="typeof workHours == 'undefined'">Loading...</span>
					<span ez-if="typeof workHours != 'undefined'">
						<div class="no-results" ez-if="workHours.length == 0">Geen resultaten gevonden</div>
						<div ez-if="workHours.length > 0">
							<table class="table">
								<thead>
									<tr>
										<th style="width: 25px;">#</th>
										<th>{{_('Description')}}</th>
										<th style="width: 140px;">{{_('Edited')}}</th>
									</tr>
								</thead>
								
								<tbody ez-for="workHours" ez-item="wh">
									<tr class="pointer" data-work-hour-id="{{wh.workHourId}}" [onclick]="widget.workHour_Click">
										<td>{{ wh.workHourId }}</td>
										<td>
											<div>{{work_hour_moment_text( wh )}}</div>
											<div>{{ ifnull(wh.customerName, '')  }}</div>
											<div>{{ wh.shortDescription  }}</div>
										</td>
										<td>{{ format_datetime_minutes(wh.edited) }}</td>
									</tr>
								</tbody>
							</table>
						</div>
					</span>
				</div>
			</div>
		
		
			<div class="dashboard-widget col-md-6 col-sm-12" ez-subtemplate="subfeedback">
				<div class="title" title="Laatste 50">{{_('Leads / Actions')}}</div>
				<div class="content">
					<span ez-if="typeof feedback == 'undefined'">Loading...</span>
					<span ez-if="typeof feedback != 'undefined'">
						<div class="no-results" ez-if="feedback.length == 0">Geen resultaten gevonden</div>
						<div ez-if="feedback.length > 0">
							<table class="table">
								<thead>
									<tr>
										<th style="width: 25px;">#</th>
										<th>{{_('Description')}}</th>
										<th style="width: 140px;">{{_('Edited')}}</th>
									</tr>
								</thead>
								
								<tbody ez-for="feedback" ez-item="f">
									<tr class="pointer" data-feedback-id="{{f.workFeedbackId}}" [onclick]="widget.workFeedback_Click">
										<td>{{ f.workFeedbackId }}</td>
										<td>
											<div>{{ ifnull(f.customerName, '')  }}</div>
											<div>{{ f.shortDescription  }}</div>
											
											<div ez-if="valid_date(f.deadline)">
												{{_('Deadline')}}
												{{format_datetime_minutes( f.deadline, {showZero: false})}}
											</div>
										</td>
										<td>{{ format_datetime_minutes(f.edited) }}</td>
									</tr>
								</tbody>
							</table>
						</div>
					</span>
				</div>
			</div>
			
			
			
			<div class="dashboard-widget col-md-6 col-sm-12" ez-subtemplate="recentactivities">
				<div class="title" title="Laatste 50">Logboek</div>
				<div class="content">
					<span ez-if="typeof acts == 'undefined'">Loading...</span>
					<span ez-if="typeof acts != 'undefined'">
						<div class="no-results" ez-if="acts.length == 0">Geen resultaten gevonden</div>
						<div ez-if="acts.length > 0">
							<table class="table">
								<thead>
									<tr>
										<th>#</th>
										<th>Omschrijving</th>
										<th>Tijdstip</th>
									</tr>
								</thead>
								
								<tbody ez-for="acts" ez-item="ac">
									<tr class="pointer" data-activity-id="{{ac.activityId}}" [onclick]="widget.clickActivity">
										<td>{{ ac.activityId }}</td>
										<td>{{ ac.shortDescription  }}</td>
										<td>{{ format_datetime_minutes(ac.created) }}</td>
									</tr>
								</tbody>
							</table>
						</div>
					</span>
				</div>
			</div>
		</div>
	</div>
	`;
	
	
	timeout_loadActivity = null;
	timeout_loadWorkOrder = null;
	timeout_loadWorkHour = null;
	timeout_loadWorkFeedback = null;
	
	
	constructor() {
		
	}
	
	init( selector ) {
		let et = new EzTemplate( selector );
		et.loadHtml( this.tpl );
		et.build();
		et.setObject('widget', this);
		et.render();
		
		document.querySelector('.rtob-dashboard-widget').widget = this;
		
		this.loadRecentActivities();
		
		this.loadWorkOrders();
		
		this.loadHours();
		
		this.loadFeedback();
	}
	
	async loadWorkOrders() {
		if (appConfig.hasPermission('up.rtob_work_orders') == false) {
			$('[ez-subtemplate=subworkorders]').remove();
			return;
		}
		
		let r = await postUrl("/service/work/list.do", {
			lastEdited: 25
		});
		
		let json = await r.json();
		let tpl = $('[ez-subtemplate="subworkorders"]').get(0).eztemplate;
		tpl.setVar('workOrders', json.workOrders);
		tpl.render();
	}
	workOrder_Click(evt, obj) {
		let wo_id = obj.dataset['workOrderId'];
		
		gotoRoute('/work/edit/?id='+wo_id);
	}

	async loadHours() {
		if (appConfig.hasPermission('up.rtob_work_hours') == false) {
			$('[ez-subtemplate=subhours]').remove();
			return;
		}
		
		let r = await postUrl("/service/hour/list.do", {
			lastEdited: 25
		});
		
		let json = await r.json();
		let tpl = $('[ez-subtemplate="subhours"]').get(0).eztemplate;
		tpl.setVar('workHours', json.workhours);
		tpl.render();
	}
	
	workHour_Click( evt, obj ) {
		let wh_id = obj.dataset['workHourId'];
		
		gotoRoute('/hour/edit/?id='+wh_id);
	}
	
	
	
	async loadFeedback() {
		if (appConfig.hasPermission('up.rtob_work_feedback') == false) {
			$('[ez-subtemplate=subfeedback]').remove();
			return;
		}
		
		let r = await postUrl("/service/feedback/list.do", {
			lastEdited: 25
		});
		
		let json = await r.json();
		let tpl = $('[ez-subtemplate="subfeedback"]').get(0).eztemplate;
		tpl.setVar('feedback', json.feedbacks);
		tpl.render();
	}
	workFeedback_Click( evt, obj ) {
		let f_id = obj.dataset['feedbackId'];
		
		gotoRoute('/feedback/edit/?id='+f_id);
	}
		
	
	
	loadRecentActivities() {
		
		if (appConfig.isAdmin() == false) {
			$('[ez-subtemplate=recentactivities]').remove();
			return;
		}
		
		
		postUrl("/service/activity.do")
		.then( async function(e) {
			let json = await e.json();
			let tpl = $('[ez-subtemplate="recentactivities"]').get(0).eztemplate;
			tpl.setVar('acts', json.acts);
			tpl.render();
		}.bind(this));
	}
	
	clickActivity(evt) {
		let activityId = $(evt.currentTarget).data('activity-id');
		
		let ap = new ActivityPopup( activityId );
		ap.showPopup();
	}
	
	
	
	handleEvent( data ) {
		
		let objectChanged = data.substring( 'ObjectChanged:'.length );
		
		if (objectChanged == 'itx.erp.base.model.Activity') {
			clearTimeout( this.timeout_loadActivity );
			this.timeout_loadActivity = setTimeout(() => {
				this.loadRecentActivities();
			}, 300);
		}
		
		if (objectChanged == 'itx.r2b.model.WorkOrder') {
			clearTimeout( this.timeout_loadWorkOrders );
			this.timeout_loadWorkOrders = setTimeout(() => {
				this.loadWorkOrders();
			}, 300);
		}
		if (objectChanged == 'itx.r2b.model.WorkHour') {
			clearTimeout( this.timeout_loadWorkHour );
			this.timeout_loadWorkHour = setTimeout(() => {
				this.loadHours();
			}, 300);
		}
		if (objectChanged == 'itx.r2b.model.WorkFeedback') {
			clearTimeout( this.timeout_loadWorkFeedback );
			this.timeout_loadWorkFeedback = setTimeout(() => {
				this.loadFeedback();
			}, 300);
		}
	}
	
	
}

