
import { ActivityLogTab } from '../../masterdata/activity/ActivityLogTab.js';
import { PermissionsWidget } from '../../auth/PermissionsWidget.js';
import { appConfig } from '../../../service/AppConfig.js';


export class FeedbackEditWidget {
	
	
	tpl = `
		<div class="feedback-edit-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.back_Click" class="fa fa-chevron-circle-left"></a>
					
					<span ez-if="isNew == false">
						<a [onclick]="widget.delete_Click" class="fa fa-trash"></a>
					</span>
					
					<a [onclick]="widget.save_Click" class="fa fa-save"></a>
				</div>
			
				<h1>
					{{isNew ? _('Add feedback') : _('Edit feedback') + ' #'+f.workFeedbackId}}
				</h1>
			</div>
			
			<div ez-if="loading == true">Loading...</div>
			
			<div ez-if="loading == false">
				<ul class="nav nav-tabs" id="feedbackTabs" role="tablist">
					<li class="nav-item" role="presentation">
						<button class="nav-link active" id="base-tab" data-bs-toggle="tab" data-bs-target="#feedback-base" type="button" role="tab" aria-controls="base" aria-selected="true">Basisgegevens</button>
					</li>
				</ul>
	
				<div class="tab-content" id="feedbackTabsContent">
					<div class="tab-pane fade show active" id="feedback-base" role="tabpanel" aria-labelledby="base-tab">
	
						<div ez-if="loading">
							Loading...
						</div>
						
						<form id="frmFeedback" ez-if="loading == false">
							<ez-select name="status"
										label="{{_('Status')}}"
										[value]="f.status">
								<option value="open">{{_('Open')}}</option>
								<option value="inprogress">{{_('In progress')}}</option>
								<option value="cancelled">{{_('Cancelled')}}</option>
								<option value="done">{{_('Done')}}</option>
							</ez-select>
							
							<ez-customer name="customerId"
								label="{{_('Relation')}}"
								[value]="f.customerId"
								[valuetext]="f.customerName"></ez-customer>
								
							
							<ez-select name="feedbackType"
										label="{{_('Feedback type')}}"
										[value]="f.feedbackType">
								<option value="lead">{{_('Lead')}}</option>
								<option value="action">{{_('Action')}}</option>
								<option value="reminder">{{_('Reminder')}}</option>
								<option value="note">{{_('Note')}}</option>
							</ez-select>
							
							<ez-text name="shortDescription"
									label="{{_('Description')}}" 
									[onchange]="widget.shortDescription_Change"
									[value]="f.shortDescription"></ez-text>
							
							
							<ez-datetime name="deadline"
										label="{{_('Deadline')}}"
										[value]="f.deadline"
										showZero="false"></ez-datetime>
							
							<ez-user name="userId" 
										label="{{_('User')}}" 
										[value]="f.userId" 
										[valueText]="f.username"></ez-user>
			
							<ez-textarea name="longDescription"
									label="{{_('Long description')}}"
									[value]="f.longDescription"></ez-textarea>
							
						</form>
						
					</div>
				</div>
			</div>
			
		</div>
	`;
	
	
	container = null;
	isNew = true;
	loading = true;
	
	feedback = {
	};
	
	permissionsWidget = null;
	permissions = [];

	
	init(e) {
		this.container = e;
		
		
		let id = getUrlParam('id');
		
		if (id) {
			this.isNew = false;
			this.loading = true;
		}
		
		this.render();
		
		if (id) {
			this.loadFeedback( id );
		} else {
			this.loadDefault( );
		}
	}
	
	
	
	render() {
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('isNew', this.isNew);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('f', this.feedback);
		
		eztpl.render();
		
		this.permissionsWidget = new PermissionsWidget();
		this.permissionsWidget.init('.feedback-edit-widget');
		this.permissionsWidget.renderTab();
		this.permissionsWidget.setPermissions( this.permissions );

		
		if (appConfig.isAdmin() && this.feedback.workFeedbackId) {
			let alt = new ActivityLogTab( 'itx.r2b.model.WorkFeedback', this.feedback.workFeedbackId );
			alt.show();
		}

	}
	
	
	async loadFeedback( id ) {
		let r = await postJson('/service/feedback/edit.do', {
			a: 'view',
			workFeedbackId: id
		});
		
		let json = await r.json();
		
		this.feedback = json.feedback;
		this.permissions = json.feedback.permissions;
		
		this.loading = false;
		this.isNew = false;
		this.render();
	}
	

	async loadDefault() {
		this.loading = true;
		this.render();

		let r = await postJson('/service/feedback/edit.do', {
			a: 'defaultFeedback'
		});

		let json = await r.json();
		
		this.feedback = json.feedback;
		this.permissions = json.feedback.permissions;
		
		
		this.loading = false;
		
		this.render();
	}

	
	
	delete_Click( evt, obj ) {
		showConfirmation(_('Delete'), _('Are you sure to delete this lead/action?'), async () => {
			showLoadingForm('.feedback-edit-widget');
			
			let r = await postJson('/service/feedback/edit.do', {
				a: 'delete',
				workFeedbackId: this.feedback.workFeedbackId
			});
			
			let json = await r.json();
			
			if (json.success) {
				gotoRoute( '/feedback/' );
			}
			else {
				
				reportUserError('Error: ' + json.message);
				
				hideLoadingForm('.feedback-edit-widget');
			}
		});
	}
	
	
	back_Click() {
		gotoRoute( '/feedback/' );
	}
	
	
	shortDescription_Change( evt, obj ) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	
	async save_Click() {
		
		let frm = $('#frmFeedback');
		
		let f = {};
		
		f.status           = frm.find('select[name=status]').val();
		f.feedbackType     = frm.find('select[name=feedbackType]').val();
		f.deadline         = frm.find('input[name=deadline]').val();
		f.customerId       = frm.find('input[name=customerId]').val();
		f.userId           = frm.find('input[name=userId]').val();
		f.shortDescription = frm.find('input[name=shortDescription]').val();
		f.longDescription  = frm.find('textarea[name=longDescription]').val();
		
		if (this.feedback.workFeedbackId)
			f.workFeedbackId = this.feedback.workFeedbackId;
		
		f.permissions = this.permissionsWidget.getPermissions();
		
		f.a = 'save';
		
		showLoadingForm('.feedback-edit-widget');
		
		let r = await postJson('/service/feedback/edit.do', f);
		
		let json = await r.json();
		
		if (json.error) {
			reportUserError( 'Error: ' + json.message );
		}
		else {
			reportUserMessage( _('Changes saved') );
			replaceRoute('/feedback/edit/?id=' + json.workFeedbackId);
		}

		hideLoadingForm('.feedback-edit-widget');
	}
	
	
}



