


export class FeedbackListWidget {
	
	tpl = `
		<div class="feedback-list-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.add_Click" class="fa fa-plus"></a>
				</div>
				<h1>{{_('Leads / actions')}}</h1>
			</div>

			

			<div class="search-options-v1">
				
				<div>
					<label>Status</label>
					
					<label><input type="checkbox" name="fsOpen"       [checked]="fs.open"       /> {{_('open')}}</label>
					<label><input type="checkbox" name="fsInprogress" [checked]="fs.inprogress" /> {{_('inprogress')}}</label>
					<label><input type="checkbox" name="fsCancelled"  [checked]="fs.cancelled"  /> {{_('Cancelled')}}</label>
					<label><input type="checkbox" name="fsDone"       [checked]="fs.done"       /> {{_('done')}}</label>
				</div>
				
				<div class="search-row">
					<ez-customer name="cid" [value]="cid" [valueText]="customerName" label="{{_('Relation')}}"></ez-customer>
					
					<ez-user name="uid" [value]="uid" label="{{_('User')}}"></ez-user>
				</div>
				
				<div class="search-row">
					<ez-date name="sd" [value]="sd" label="{{_('From')}}"></ez-date>
					<ez-date name="ed" [value]="ed" label="{{_('Till')}}"></ez-date>
					
				</div>
				<div class="search-row">
					<ez-text class="q-search" name="q" [value]="q" label="" placeholder="{{_('Search...')}}"></ez-text>
				</div>
				
				<a [onclick]="widget.reset_Click">{{_('Reset')}} &gt;</a>
			</div>


			<hr/>

			<div ez-subtemplate="flist">
				<div ez-if="feedbacks == null">
					Loading...
				</div>
				
				<div ez-if="feedbacks != null">
				
					<div class="div-table tbl-feedback-list tbl-r2b-list">
						<div class="header">
							<div class="col-id">#</div>
							<div class="col-username">{{_('User')}}</div>
							<div class="col-feedback-type">{{_('Type')}}</div>
							<div class="col-customer-name">{{_('Relation')}}</div>
							<div class="col-description">{{_('Description')}}</div>
							<div class="col-deadline">{{_('Deadline')}}</div>
							<div class="col-status">{{_('Status')}}</div>
						</div>
						
						<div ez-for="feedbacks" ez-item="f">
							<div class="record" [onclick]="widget.feedback_Click" [f]="f">
								<div class="col-id">{{f.workFeedbackId}}</div>
								<div class="col-username">
									{{ifnull(f.username, '&nbsp;')}}
								</div>
								<div class="col-feedback-type">{{_('feedbacktype.'+f.feedbackType)}}</div>
								<div class="col-customer-name">{{ifnull(f.customerName, '&nbsp;')}}</div>
								<div class="col-description">{{f.shortDescription}}</div>
								<div class="col-deadline">{{format_datetime_minutes(f.deadline, {dmy:true, showZero: false})}}</div>
								<div class="col-status">{{_(f.status)}}</div>
							</div>
						</div>
						<div ez-if="feedbacks.length == 0">
							<div class="no-results-found">
								{{_('No results found')}}
							</div>
						</div>
					</div>
					
					<ez-pager></ez-pager>
				</div>
			</div>
		</div>
	`;
	
	
	loading = true;
	container = null;
	
	fs = {
		open: true,
		inprogress: true,
		cancelled: false,
		done: false
	}
	
	feedbacks = null;
	
	init(e) {
		
		this.container = e;
		
		let urlParams = getUrlParams();
		if (typeof urlParams['fsOpen'] != 'undefined')
			this.fs.open = urlParams['fsOpen'] == '1' ? true : false;
		if (typeof urlParams['fsInprogress'] != 'undefined')
			this.fs.inprogress = urlParams['fsInprogress'] == '1' ? true : false;
		if (typeof urlParams['fsCancelled'] != 'undefined')
			this.fs.cancelled = urlParams['fsCancelled'] == '1' ? true : false;
		if (typeof urlParams['fsDone'] != 'undefined')
			this.fs.done = urlParams['fsDone'] == '1' ? true : false;

		
		this.render();
		
		this.search();
	}
	
	
	render() {
		let urlParams = getUrlParams();
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('feedbacks', this.feedbacks);
		
		if (urlParams['cid'])    eztpl.setVar('cid', urlParams['cid']);
		if (urlParams['uid'])    eztpl.setVar('uid', urlParams['uid']);
		if (urlParams['sd'])     eztpl.setVar('sd', urlParams['sd']);
		if (urlParams['ed'])     eztpl.setVar('ed', urlParams['ed']);
		
		eztpl.setVar('fs', this.fs);
		
		if (urlParams['q'])      eztpl.setVar('q', urlParams['q']);
		if (urlParams['pno']) {
			let pno = parseInt(urlParams['pno']);
			if (isNaN(pno) == false && pno > 0) this.pageNo = pno;
		}
		
		eztpl.render();
		
		$('.search-options-v1').find('ez-customer, ez-user, input, select').on('change dp.change', () => {
			this.doSearch();
		});
	}
	

	getSearchParams() {
		let frm = $('.search-options-v1');
		
		let d = {};
		d.cid    = frm.find('input[name=cid]').val();
		d.uid    = frm.find('input[name=uid]').val();
		d.sd     = frm.find('input[name=sd]').val();
		d.ed     = frm.find('input[name=ed]').val();
		d.fsOpen       = frm.find('input[name=fsOpen]').prop('checked') ? 1 : 0;
		d.fsInprogress = frm.find('input[name=fsInprogress]').prop('checked') ? 1 : 0;
		d.fsCancelled  = frm.find('input[name=fsCancelled]').prop('checked') ? 1 : 0;
		d.fsDone       = frm.find('input[name=fsDone]').prop('checked') ? 1 : 0;
		d.q      = $.trim( frm.find('.q-search input[type=text]').val() );
		
		return d;
	}


	updateUri() {
		let params = this.getSearchParams();
		
		params['pno'] = this.pageNo;

		let url = '';
		for(let i in params) {
			if (url != '')
				url += '&';
			url += i + '=' + encodeURIComponent( params[i] );
		}

		url = appUrl('/feedback/') + '?' + url;

		window.history.replaceState({}, null, url);
	}

	doSearch() {
		this.pageNo = 0;
		
		this.updateUri();
		
		this.search();
	}

	

	async search( opts ) {
		opts = opts ?? {};
		
		if (this.searchAbortController != null) {
			this.searchAbortController.abort();
		}
		
		this.searchAbortController = new AbortController();
		let data = this.getSearchParams();
//		data.q = this.q;
		data.pageNo = this.pageNo;
		
		postUrl('/service/feedback/list.do'
			, data
			, {
				signal: this.searchAbortController.signal
			}
		)
		.then(async function(data) {
			let resp = await data.json();
			
			console.log( resp );
			
			if (resp.error) {
				showErrorWidget( resp );
			}
			
			
			let eztpl = $('[ez-subtemplate=flist]').get(0).eztemplate;
			
//			eztpl.setObject('widget', this);
			eztpl.setVar('feedbacks', resp.feedbacks);
			eztpl.setVar('response', resp);
			
			eztpl.render();
		}.bind(this))
		.catch( showErrorWidget )
	}

	
	
	add_Click() {
		gotoRoute( '/feedback/edit/' );
	}
	
	feedback_Click(evt, obj) {
		let f = obj.f;
		
		gotoRoute( '/feedback/edit/?id=' + f.workFeedbackId );
	}
	
	
	

	selectPage( pageNo ) {
		this.pageNo = pageNo;
		
		this.updateUri();
		
		this.search();
	}


	reset_Click() {
		gotoRoute( '/feedback/' );
	}

	
}

