


export class FeedbackTabWidget {
	
	
	
	tpl = `
	
		<div class="action-box">
			<span><a [onclick]="widget.addFeedback_Click">{{_('Add lead / action')}}</a></span>
		</div>

	
		<table class="table">
			<thead>
				<tr>
					<th style="width: 40px;">#</th>
					<th style="width: 60px;">{{_('Type')}}</th>
					<th>{{_('Description')}}</th>
					<th style="width: 120px;">{{_('Username')}}</th>
					<th style="width: 130px;">{{_('Deadline')}}</th>
					<th style="width: 115px;">{{_('Status')}}</th>
				</tr>
			</thead>
			<tbody ez-for="feedback" ez-item="f" id="feedback-tab-listing">
				<tr [onclick]="widget.feedback_Click" [f]="f" class="pointer">
					<td>{{f.workFeedbackId}}</td>
					<td>{{_('feedbacktype.'+f.feedbackType)}}</td>
					<td>{{f.shortDescription}}</td>
					<td>{{ifnull(f.username, '&nbsp;')}}</td>
					<td>{{format_datetime_minutes(f.deadline, {dmy:true, showZero: false})}}</td>
					<td>{{_(f.status)}}</td>
				</tr>
			</tbody>
			<tr id="rec-status-feedback-table">
				<td colspan="100%">Loading...</td>
			</tr>
		</table>
	`;
	
	container = null;
	customerId = null;
	
	loading = false;
	
	start = 0;
	lastResponse = null;
	
	constructor() {
		this.customerId = $('#frmCustomer input[name=customerId]').val();
		
	}
	
	
	render() {
		if (!this.customerId) {
			console.error('FeedbackTabWidget.render, customerId not set');
			return;
		}
		
		this.addTab();
		
		this.renderContent();
	}
	
	
	async loadData() {
		
		if (this.loading) return;
		
		this.loading = true;
		
		
		let r = await postJson('/service/feedback/list.do', {
			cid: this.customerId,
			start: this.start
		});
		
		let json = await r.json();
		
		
		// set next start pos
		this.start = json.start + json.pageSize;
//		console.log('this.start', this.start);
		
		
		document.querySelector('button.nav-link#feedback-tab').innerText = _('Feedback') + ' (' + json.rowCount + ')';
		
		
		let tr_f = document.getElementById('rec-status-feedback-table');
		if (json.rowCount == 0) {
			tr_f.className = 'no-results-found';
			tr_f.querySelector('td').innerText = _('No results found');
			return;
		}
		else if (json.rowCount > this.start) {
			tr_f.querySelector('td').innerHTML = '';
			
			// Load more-text
			let anch = document.createElement('a');
			anch.className = 'load-more';
			anch.innerText = _('Load more...');
			anch.addEventListener('click', () => {
				this.loadData();
			});
			tr_f.querySelector('td').appendChild( anch );
		}
		else {
			tr_f.parentNode.removeChild( tr_f );
		}
		
		
		
		// add records
		let eztpl = document.querySelector('#feedback-tab-listing').eztemplate;
		for(let i=0; i < json.feedbacks.length; i++) {
			let f = json.feedbacks[i];
			
			eztpl.createRecord( f );
		}
		
		
		this.loading = false;
	}
	
	
	
	
	addTab() {
		let li = document.createElement('li');
		li.className = 'nav-item';
		li.setAttribute('role', 'presentation');
		
		let btn = document.createElement('button');
		btn.className = 'nav-link';
		btn.setAttribute('id', 'feedback-tab');
		btn.setAttribute('data-bs-toggle', 'tab');
		btn.setAttribute('data-bs-target', '#customer-feedback');
		btn.setAttribute('type', 'button');
		btn.setAttribute('role', 'tab');
		btn.setAttribute('aria-controls', 'feedback-tab');
		btn.setAttribute('aria-selected', 'false');
		btn.innerText = _('Action / leads');
		
		li.appendChild( btn );
		
		
		insertNodeAtPos( '#customerTabs > li', 3, li );
	}
	
	
	renderContent() {
		if (this.container == null) {
			let pane = document.createElement('div');
			pane.className = 'tab-pane fade';
			pane.setAttribute('id', 'customer-feedback');
			pane.setAttribute('role', 'tabpanel');
			pane.setAttribute('aria-labelledby', 'feedback-tab');
			document.getElementById('customerTabsContent').appendChild( pane );
			
			this.container = pane;
		}
		
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		
		eztpl.setVar('loading', this.loading);
		
		eztpl.render();
		
		this.loadData();
	}
	
	
	feedback_Click( evt, obj ) {
		let f = obj.f;
		
		gotoRoute('/feedback/edit/?id='+f.workFeedbackId);
	}
	
	
	addFeedback_Click() {
		gotoRoute('/feedback/edit/?selected_cid=' + this.customerId);
	}
}


