
import { ActivityLogTab } from '../../masterdata/activity/ActivityLogTab.js';
import { PermissionsWidget } from '../../auth/PermissionsWidget.js';
import { appConfig } from '../../../service/AppConfig.js';


export class WorkHourEditWidget {
	
	
	tpl = `
		<div class="work-hour-edit-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.back_Click" class="fa fa-chevron-circle-left"></a>
					
					<span ez-if="isNew == false">
					<a [onclick]="widget.delete_Click" class="fa fa-trash"></a>
					</span>
					
					<a [onclick]="widget.save_Click" class="fa fa-save"></a>
				</div>
			
				<h1>
					{{isNew ? _('Add hour') : _('Edit hour') + ' #' + h.workHourId}}
				</h1>
			</div>
			
			<ul class="nav nav-tabs" id="hourTabs" role="tablist">
				<li class="nav-item" role="presentation">
					<button class="nav-link active" id="base-tab" data-bs-toggle="tab" data-bs-target="#hour-base" type="button" role="tab" aria-controls="base" aria-selected="true">Basisgegevens</button>
				</li>
			</ul>

			<div class="tab-content" id="hourTabsContent">
				<div class="tab-pane fade show active" id="hour-base" role="tabpanel" aria-labelledby="base-tab">

					<div ez-if="loading">
						Loading...
					</div>
					
					<form id="frmHour" ez-if="loading == false">
						<ez-select name="reportStatus"
									label="{{_('Status')}}"
									[value]="h.reportStatus">
							<option value="open">{{_('reportStatus.open')}}</option>
							<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
							<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
							<option value="processed">{{_('reportStatus.processed')}}</option>
						</ez-select>
						
						<ez-customer name="customerId"
									[value]="h.customerId"
									[valuetext]="h.customerName"
									label="{{_('Relation')}}"></ez-customer>
		
						<ez-text name="shortDescription"
								label="{{_('Description')}}"
								[onchange]="widget.shortDescription_Change" 
								[value]="h.shortDescription"></ez-text>
						
						
						<ez-radio name="timingType"
								label="{{_('Type')}}"
								[value]="h.timingType"
								[onchange]="widget.toggleHourType">
							<option value="from_to">{{_('From to')}}</option>
							<option value="duration">{{_('Duration')}}</option>
						</ez-radio>
						
						
						<ez-datetime name="startTime"
									label="{{_('Start time')}}"
									showZero="false"
									[value]="h.startTime"></ez-datetime>
						<ez-datetime name="endTime"
									label="{{_('End time')}}"
									showZero="false"
									[value]="h.endTime"></ez-datetime>
						<ez-number name="duration"
									label="{{_('Duration')}}"
									min="0"
									[value]="h.duration"></ez-number>
						
						<ez-user name="userId" 
									label="{{_('User')}}" 
									[value]="h.userId" 
									[valueText]="h.username"></ez-user>
						
						<ez-textarea name="longDescription"
								label="{{_('Long description')}}"
								[value]="h.longDescription"></ez-textarea>
					</form>
					
				</div>
			</div>
		</div>
	`;
	
	
	container = null;
	isNew = true;
	loading = false;
	
	hour = {
		timingType: 'from_to'
	};
	
	permissionsWidget = null;
	permissions = [];

	
	init(e) {
		this.container = e;
		
		
		let id = getUrlParam('id');
		
		if (id) {
			this.isNew = false;
			this.loading = true;
		}
		
		if (id) {
			this.loadHour( id );
		}
		else {
			this.loadDefault();
		}
	}
	
	
	
	render() {
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('isNew', this.isNew);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('h', this.hour);
		
		
		eztpl.render();
		
		this.toggleHourType();
		
		
		this.permissionsWidget = new PermissionsWidget();
		this.permissionsWidget.init('.work-hour-edit-widget');
		this.permissionsWidget.renderTab();
		this.permissionsWidget.setPermissions( this.permissions );

		
		if (appConfig.isAdmin() && this.hour.workHourId) {
			let alt = new ActivityLogTab( 'itx.r2b.model.WorkHour', this.hour.workHourId );
			alt.show();
		}
	}
	
	
	async loadHour( id ) {
		let r = await postJson('/service/hour/edit.do', {
			a: 'view',
			workHourId: id
		});
		
		let json = await r.json();
		
		this.hour = json.hour;
		this.permissions = json.hour.permissions;
		
		this.loading = false;
		this.isNew = false;
		this.render();
	}
	
	

	async loadDefault() {
		this.loading = true;
		this.render();

		let r = await postJson('/service/hour/edit.do', {
			a: 'defaultHour',
			selected_cid: getUrlParam('selected_cid')
		});

		let json = await r.json();
		
		this.hour = json.hour;
		this.permissions = json.hour.permissions;
		
		
		this.loading = false;
		
		this.render();
	}

	
	
	back_Click() {
		gotoRoute( '/hour/' );
	}
	
	
	toggleHourType() {
		let t = $(this.container).find('input[name=timingType]:checked').val();
		
		if (t == 'from_to') {
			$('ez-datetime[name=endTime]').show();
			$('ez-number[name=duration]').hide();
		}
		// 'duration'
		else {
			$('ez-datetime[name=endTime]').hide();
			$('ez-number[name=duration]').show();
		}
		
	}
	
	
	async save_Click() {
		let frm = $('#frmHour');
		
		let h = {};
		
		h.reportStatus     = frm.find('select[name=reportStatus]').val();
		h.customerId       = frm.find('input[name=customerId]').val();
		h.userId           = frm.find('input[name=userId]').val();
		h.shortDescription = frm.find('input[name=shortDescription]').val();
		h.timingType       = frm.find('input[name=timingType]:checked').val();
		h.startTime        = frm.find('input[name=startTime]').val();
		h.endTime          = frm.find('input[name=endTime]').val();
		h.duration         = frm.find('input[name=duration]').val();
		h.longDescription  = frm.find('textarea[name=longDescription]').val();
		
		if (this.hour.workHourId)
			h.workHourId = this.hour.workHourId;
		
		h.permissions = this.permissionsWidget.getPermissions();
		
		h.a = 'save';
		
		showLoadingForm('.work-hour-edit-widget');
		
		let r = await postJson('/service/hour/edit.do', h);
		
		let json = await r.json();
		
		if (json.error) {
//			reportUserError( 'Error: ' + json.message );
			formShowErrors('#frmHour', json);
		}
		else {
			reportUserMessage( _('Changes saved') );
			replaceRoute('/hour/edit/?id=' + json.workHourId);
		}

		hideLoadingForm('.work-hour-edit-widget');
	}
	
	
	shortDescription_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	delete_Click(evt, obj) {
		showConfirmation(_('Delete'), _('Are you sure to delete this hour?'), async () => {
			showLoadingForm('.work-hour-edit-widget');
			
			let r = await postJson('/service/hour/edit.do', {
				a: 'delete',
				workHourId: this.hour.workHourId
			});
			
			let json = await r.json();
			
			if (json.success) {
				gotoRoute( '/hour/' );
			}
			else {
				
				reportUserError('Error: ' + json.message);
				
				hideLoadingForm('.work-hour-edit-widget');
			}
		});
	}
	
	
}



