


export class WorkHourListWidget {
	
	tpl = `
		<div class="work-hour-list-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.add_Click" class="fa fa-plus"></a>
				</div>
				<h1>Uren</h1>
			</div>

			<div class="search-options-v1">
				<div class="search-row">
					<ez-customer name="cid" [value]="cid" [valueText]="customerName" label="{{_('Relation')}}"></ez-customer>
					
					<ez-user name="uid" [value]="uid" label="{{_('User')}}"></ez-user>
				</div>
				
				<div class="search-row">
					<ez-date name="sd" [value]="sd" label="{{_('From')}}"></ez-date>
					<ez-date name="ed" [value]="ed" label="{{_('Till')}}"></ez-date>
					
					<ez-select name="rs" [value]="status" label="{{_('Status')}}">
						<option value="">{{_('Make your choice')}}</option>
						<option value="open">{{_('reportStatus.open')}}</option>
						<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
						<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
						<option value="processed">{{_('reportStatus.processed')}}</option>
					</ez-select>
				</div>
				<div class="search-row">
					<ez-text class="q-search" name="q" [value]="q" label="" placeholder="{{_('Search...')}}"></ez-text>
				</div>
				
				<a [onclick]="widget.reset_Click">{{_('Reset')}} &gt;</a>
			</div>


			<hr/>

			<div ez-subtemplate="whlist">
				<div ez-if="workhours == null">
					Loading...
				</div>
				
				<div ez-if="workhours != null">
				
					<div class="div-table tbl-whours-list tbl-r2b-list">
						<div class="header">
							<div class="col-id">#</div>
							<div class="col-customer-name">{{_('Relation')}}</div>
							<div class="col-description">{{_('Description')}}</div>
							<div class="col-start-time">{{_('Start')}}</div>
							<div class="col-duration">{{_('Duration')}}</div>
							<div class="col-username">{{_('User')}}</div>
							<div class="col-status">{{_('Status')}}</div>
						</div>
						
						<div ez-for="workhours" ez-item="wh">
							<div class="record" [onclick]="widget.hour_Click" [wh]="wh">
								<div class="col-id">{{wh.workHourId}}</div>
								<div class="col-customer-name">{{ifnull(wh.customerName, '&nbsp;')}}</div>
								<div class="col-description">{{ifnull(wh.shortDescription, '&nbsp;')}}</div>
								<div class="col-start-time">{{format_datetime_minutes(wh.startTime, {dmy:true, showZero: false})}}</div>
								<div class="col-duration">
									{{ wh.timingType == 'from_to' ? str_hoursBetween( wh.startTime, wh.endTime ) : str_fraction2hours( wh.duration ) }}
								</div>
								<div class="col-username">{{ifnull(wh.username, '&nbsp;')}}</div>
								<div class="col-status">{{_('reportStatus.'+wh.reportStatus)}}</div>
							</div>
						</div>
						<div ez-if="workhours.length == 0">
							<div class="no-results-found">
								{{_('No results found')}}
							</div>
						</div>
					</div>
					
					<ez-pager></ez-pager>
				</div>
			</div>
		</div>
	`;
	
	
	loading = true;
	container = null;
	
	pageNo = 0;
	
	workhours = null;
	
	searching = false;
	
	init(e) {
		
		this.container = e;
		
		this.render();
		
		this.search();
	}
	
	
	render() {
		let urlParams = getUrlParams();
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('workhours', this.workhours);
		
		if (urlParams['cid'])    eztpl.setVar('cid', urlParams['cid']);
		if (urlParams['uid'])    eztpl.setVar('uid', urlParams['uid']);
		if (urlParams['sd'])     eztpl.setVar('sd', urlParams['sd']);
		if (urlParams['ed'])     eztpl.setVar('ed', urlParams['ed']);
		if (urlParams['rs'])     eztpl.setVar('rs', urlParams['rs']);
		if (urlParams['q'])      eztpl.setVar('q', urlParams['q']);
				
		eztpl.render();
		
		$('.search-options-v1').find('ez-customer, ez-user, input, select').on('change dp.change', () => {
			this.doSearch();
		});
	}
	
	
	


	getSearchParams() {
		let frm = $('.search-options-v1');
		
		let d = {};
		d.cid    = frm.find('input[name=cid]').val();
		d.uid    = frm.find('input[name=uid]').val();
		d.sd     = frm.find('input[name=sd]').val();
		d.ed     = frm.find('input[name=ed]').val();
		d.rs     = frm.find('select[name=rs]').val();
		d.q      = $.trim( frm.find('.q-search input[type=text]').val() );
		
		return d;
	}


	doSearch() {
		let params = this.getSearchParams();
		console.log(params);
		
		
		let url = '';
		for(let i in params) {
			if (url != '')
				url += '&';
			url += i + '=' + encodeURIComponent( params[i] );
		}
		
		url = appUrl('/hour/') + '?' + url;
		
		
		window.history.replaceState({}, null, url);
		
		this.pageNo = 0;
		
		this.search();
	}
	

	async search( opts ) {
		opts = opts ?? {};
		
		if (this.searching)
			return;
		
		this.searching = true;
		
		if (this.searchAbortController != null) {
			this.searchAbortController.abort();
		}
		
		this.searchAbortController = new AbortController();
		let data = this.getSearchParams();
//		data.q = this.q;
		data.pageNo = this.pageNo;
		
		postUrl('/service/hour/list.do'
			, data
			, {
				signal: this.searchAbortController.signal
			}
		)
		.then(async (data) => {
			let resp = await data.json();
			
			console.log( resp );
			
			if (resp.error) {
				showErrorWidget( resp );
			}
			
			
			let eztpl = $('[ez-subtemplate=whlist]').get(0).eztemplate;
			
//			eztpl.setObject('widget', this);
			eztpl.setVar('workhours', resp.workhours);
			eztpl.setVar('response', resp);
			
			eztpl.render();
		})
		.catch( showErrorWidget )
		.finally(() => {
			this.searching = false;
		})
	}
	
	selectPage( pageNo ) {
		this.pageNo = pageNo;
		this.search();
	}


	
	
	add_Click() {
		gotoRoute( '/hour/edit/' );
	}
	
	hour_Click(evt, obj) {
		let h = obj.wh;
		
		gotoRoute( '/hour/edit/?id=' + h.workHourId );
	}
	
	
	reset_Click() {
		gotoRoute( '/hour/' );
	}
	
}

