


export class WorkHourTabWidget {
	
	
	
	tpl = `
	
		<div class="action-box">
			<span><a [onclick]="widget.addWorkHour_Click">{{_('Add work hour')}}</a></span>
		</div>

		<table class="table">
			<thead>
				<tr>
					<th style="width: 40px;">#</th>
					<th>{{_('Description')}}</th>
					<th style="width: 130px;">{{_('Start')}}</th>
					<th style="width: 130px;">{{_('Duration')}}</th>
					<th style="width: 120px;">{{_('Username')}}</th>
					<th style="width: 80px;">{{_('Status')}}</th>
				</tr>
			</thead>
			<tbody ez-for="hours" ez-item="wh" id="wh-listing">
				<tr [onclick]="widget.wh_Click" [wh]="wh" class="pointer">
					<td>{{wh.workHourId}}</td>
					<td>{{wh.shortDescription}}</td>
					<td>{{format_datetime_minutes(wh.startTime, {dmy:true, showZero: false})}}</td>
					<td>
					{{ wh.timingType == 'from_to' ? str_hoursBetween( wh.startTime, wh.endTime ) : str_fraction2hours( wh.duration ) }}
					</td>
					<td>{{ifnull(wh.username, '&nbsp;')}}</td>
					<td>{{_(wh.status)}}</td>
				</tr>
			</tbody>
			<tr id="rec-feedback-work-hour-table">
				<td colspan="100%">Loading...</td>
			</tr>
		</table>
	`;
	
	container = null;
	customerId = null;
	
	loading = false;
	
	start = 0;
	lastResponse = null;
	
	constructor() {
		this.customerId = $('#frmCustomer input[name=customerId]').val();
		
	}
	
	
	render() {
		if (!this.customerId) {
			console.error('WorkHourTabWidget.render, customerId not set');
			return;
		}
		
		this.addTab();
		
		this.renderContent();
	}
	
	
	async loadData() {
		
		if (this.loading) return;
		
		this.loading = true;
		
		
		let r = await postJson('/service/hour/list.do', {
			cid: this.customerId,
			start: this.start
		});
		
		let json = await r.json();
		
		
		// set next start pos
		this.start = json.start + json.pageSize;
		
		
		document.querySelector('button.nav-link#workhours-tab').innerText = _('Hours') + ' (' + json.rowCount + ')';
		
		
		let tr_f = document.getElementById('rec-feedback-work-hour-table');
		if (json.rowCount == 0) {
			tr_f.className = 'no-results-found';
			tr_f.querySelector('td').innerText = _('No results found');
			return;
		}
		else if (json.rowCount > this.start) {
			tr_f.querySelector('td').innerHTML = '';
			
			// Load more-text
			let anch = document.createElement('a');
			anch.className = 'load-more';
			anch.innerText = _('Load more...');
			anch.addEventListener('click', () => {
				this.loadData();
			});
			tr_f.querySelector('td').appendChild( anch );
		}
		else {
			tr_f.parentNode.removeChild( tr_f );
		}
		
		
		
		// add records
		let eztpl = document.querySelector('#wh-listing').eztemplate;
		for(let i=0; i < json.workhours.length; i++) {
			let wh = json.workhours[i];
			
			eztpl.createRecord( wh );
		}
		
		
		// load-more
		
		
		
//		console.log(eztpl);
		
		this.loading = false;
		
	}
	
	
	
	
	addTab() {
		let li = document.createElement('li');
		li.className = 'nav-item';
		li.setAttribute('role', 'presentation');
		
		let btn = document.createElement('button');
		btn.className = 'nav-link';
		btn.setAttribute('id', 'workhours-tab');
		btn.setAttribute('data-bs-toggle', 'tab');
		btn.setAttribute('data-bs-target', '#customer-workhours');
		btn.setAttribute('type', 'button');
		btn.setAttribute('role', 'tab');
		btn.setAttribute('aria-controls', 'workhours-tab');
		btn.setAttribute('aria-selected', 'false');
		btn.innerText = _('Hours');
		
		li.appendChild( btn );
		
		
		insertNodeAtPos( '#customerTabs > li', 2, li );
	}
	
	
	renderContent() {
		if (this.container == null) {
			let pane = document.createElement('div');
			pane.className = 'tab-pane fade';
			pane.setAttribute('id', 'customer-workhours');
			pane.setAttribute('role', 'tabpanel');
			pane.setAttribute('aria-labelledby', 'workhours-tab');
			document.getElementById('customerTabsContent').appendChild( pane );
			
			this.container = pane;
		}
		
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		
		eztpl.setVar('loading', this.loading);
		
		eztpl.render();
		
		this.loadData();
	}
	
	
	wh_Click( evt, obj ) {
		let wh = obj.wh;
		
		gotoRoute('/hour/edit/?id='+wh.workHourId);
	}
	
	
	addWorkHour_Click() {
		gotoRoute('/hour/edit/?selected_cid='+this.customerId);
	}
}


