

export class RtobSettingsWidget {
	
	
	tpl = `
	<div class="rtob-settings-widget">
		<div class="page-header">
			<div class="toolbox">
				<a [onclick]="widget.back_Click" class="fa fa-chevron-circle-left"></a>
				<a [onclick]="widget.save_Click" class="fa fa-save"></a>
			</div>
			
			<h1>{{_('Generic settings')}}</h1>
		</div>
		
		<div ez-if="loading == true">
			Loading...
		</div>
		
		<div class="form form-rtob-settings" ez-if="loading == false">
			<fieldset>
				<legend>{{_('Hours')}}</legend>
				
				<ez-radio name="hoursDefaultTimingType" 
							label="{{_('Default timing type')}}"
							[value]="settings.hoursDefaultTimingType">
					<option value="from_to">{{_('From to')}}</option>
					<option value="duration">{{_('Duration')}}</option>
				</ez-radio>
			</fieldset>
		</div>
	
	</div>
	`;
	
	
	
	container = null;
	
	loading = true;
	
	settings = {};
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadSettings();
	}
	
	async loadSettings() {
		
		let r = await postJson('/service/r2b/rtobsettings.do');
		let json = await r.json();
		
		this.settings = json;
		this.loading = false;
		this.render();
	}
	
	
	
	render() {
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('settings', this.settings);
		
		eztpl.render();
	}
	
	
	
	back_Click() {
		gotoRoute('/masterdata/');
	}
	
	
	async save_Click() {
		
		let d = {};
		d.a = 'save';
		d.hoursDefaultTimingType = $('input[name=hoursDefaultTimingType]:checked').val();
		
		showLoadingForm('.form-rtob-settings');
		
		let r = await postJson('/service/r2b/rtobsettings.do', d);
		let json = await r.json();
		
		if (json.success) {
			reportUserMessage(_('Changes saved'));
			replaceRoute('/masterdata/rtobsettings/');
		}
		else {
			hideLoadingForm('.form-rtob-settings');
			reportUserError(_('Error') + ': ' + json.message);
		}
	}
	
}


