_
import { listSimpleFormWidgets, lookupSimpleFormWidget } from '../../simpleform/widgets/helper.js';
import { FileUploadPickPopup } from '../../files/FileUploadPickPopup.js';
import { SampleFilePopup } from '../../files/SampleFilePopup.js';
import { ActivityLogTab } from '../../masterdata/activity/ActivityLogTab.js';
import { PermissionsWidget } from '../../auth/PermissionsWidget.js';
import { appConfig } from '../../../service/AppConfig.js';


export class WorkEditWidget {
	tpl = `
		<div class="work-edit-widget simple-form-edit-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.back_Click" class="fa fa-chevron-circle-left"></a>
					
					<span ez-if="isNew == false">
						<a [onclick]="widget.delete_Click" class="fa fa-trash"></a>
					</span>
					
					<a [onclick]="widget.save_Click" class="fa fa-save"></a>
				</div>
				<h1>{{isNew ? _('Add work order') : _('Edit work order') + ' #' + wo.workOrderId}}</h1>
			</div>
			
			<ul class="nav nav-tabs" id="workOrderTabs" role="tablist">
				<li class="nav-item" role="presentation">
					<button class="nav-link active" id="base-tab" data-bs-toggle="tab" data-bs-target="#work-base" type="button" role="tab" aria-controls="base" aria-selected="true">Basisgegevens</button>
				</li>
				
			</ul>

			<div class="tab-content" id="workOrderTabsContent">
			
				<div class="tab-pane fade show active" id="work-base" role="tabpanel" aria-labelledby="base-tab">
					<div ez-if="loading == true">
						<img src="/static/img/ajax-loader-small.gif" /> Loading..
					</div>
					
					<div ez-if="loading == false">
						<div class="work-head form">
							<ez-select label="{{_('Status')}}" name="status" [value]="wo.status">
								<option value="open">{{_('Open')}}</option>
								<option value="inprogress">{{_('In progress')}}</option>
								<option value="cancelled">{{_('Cancelled')}}</option>
								<option value="processed">{{_('reportStatus.processed')}}</option>
							</ez-select>
							
							<ez-customer label="{{_('Relation')}}" name="customerId" [valueText]="wo.customerName" [value]="wo.customerId"></ez-customer>
							
							
							<ez-text label="{{_('Description')}}" name="description" [value]="wo.description"></ez-text>
							
							<ez-text label="{{_('Location')}}" name="locationText" [value]="wo.locationText"></ez-text>
							
							<ez-datetime label="{{_('Timestamp')}}" name="orderDate" showZero="false" [value]="wo.orderDate"></ez-datetime>
							
							<ez-user name="userId" [valueText]="wo.username" [value]="wo.userId"></ez-user>
						</div>
						
						<hr/>
							<div class="files-container">
								<div class="file-list"></div>
								<div class="vertical-center" style="padding-left: 10px;">
									<a [onclick]="widget.addFile_Click" class="fa fa-plus add-file"></a>
								</div>
							</div>
						
						<hr/>
						
						<div class="work-editor">
							<div class="left-side">
								<div class="widget-list"></div>
								
								<div class="form-list"></div>
							</div>
							
							<div class="wo-container form-sample">
								<div class="sample-empty-text">{{_('Add a widget')}}</div>
							</div>
							
							<div class="widget-properties"></div>
						</div>
					</div>
				</div>
				
				
			</div>
		</div>
	`;

	tplProps = `
		<div class="sf-props">
		
			<div class="title">
				{{sfw.widgetDescription}}
			</div>
		
			<div class="property-list"></div>
			
		</div>
	`;

	

	input_counter = 0;
	writable = true;

	isNew     = true;
	container = null;
	loading   = false;
	widgets   = null;

	defaultSelectedForm = null;
	workOrder = {
		description: '',
		locationText: '',
		workOrderId: 0,
		description: '',
		orderDate: format_date(new Date(), {dmy: true}),
		status: 'open'
	};
	files = [];
	
	permissionsWidget = null;
	permissions = [];
	
	
	init(e) {
		this.container = e;
		
		this.widgets = listSimpleFormWidgets();
		
		let id = getUrlParam( 'id' );
		this.loading = true;
		if (id) {
			this.loadWork( id );
		}
		else {
			this.loadDefault();
		}
	}
	
	render() {
		let eztpl = new EzTemplate(this.container);
		eztpl.loadHtml(this.tpl);
		eztpl.setObject('widget', this);
		eztpl.setVar('isNew', this.isNew);
		eztpl.setVar('loading', this.loading);

		eztpl.setVar('wo', this.workOrder);

		eztpl.render();
		
		$('<a class="fa fa-map-location" id="btn-goto-location"></a>').insertAfter( 'ez-text[name=locationText] input[type=text]' );
		$('#btn-goto-location').on('click', () => {
			this.gotoLocation_Click();
		});

		if (this.loading) return;
		
		$(this.container).find('input[name=description], input[name=locationText]').on('change', function() {
			this.value = trim(this.value);
		});

		this.renderWidgetItemsList();
		this.renderFormList();
		
		this.renderWidgets();
		
		this.renderFiles();
		
		$('.form-sample').sortable({
			axis: 'y',
			handle: '.sort-handle'
		});

		
		this.permissionsWidget = new PermissionsWidget();
		this.permissionsWidget.init('.work-edit-widget');
		this.permissionsWidget.renderTab();
		this.permissionsWidget.setPermissions( this.permissions );
		
		if (appConfig.isAdmin() && this.workOrder.workOrderId) {
			let alt = new ActivityLogTab( 'itx.r2b.model.WorkOrder', this.workOrder.workOrderId );
			alt.show();
		}
	}
	
	async loadWork( workOrderId ) {
		this.loading = true;
		
		let r = await postJson('/service/work/edit.do', {
			a: 'view',
			workOrderId: workOrderId
		});
		
		let json = await r.json();
		
		this.workOrder = json.work;
//		this.widgets = json.work.widgets;

		this.files = json.work.files;
		
		this.permissions = json.work.permissions;
		
		this.loading = false;
		this.isNew = false;
		
		this.render();
	}
	
	async loadDefault() {
		this.loading = true;
		this.render();

		let r = await postJson('/service/work/edit.do', {
			a: 'defaultWorkOrder',
			selected_cid: getUrlParam('selected_cid')
		});

		let json = await r.json();
		
		this.defaultSelectedForm = json.defaultForm;
		
		this.workOrder = json.work;
		this.permissions = json.work.permissions;
		
		
		this.loading = false;
		
		this.render();
		
		

		// auto set default form
		if (this.defaultSelectedForm != null) {
			let form = this.defaultSelectedForm;
			
			for(let i=0; i < form.widgets.length; i++) {
				let w = lookupSimpleFormWidget( form.widgets[i].widgetType );
				
				let opts = form.widgets[i];
				let ref = 'sfw_'+form.simpleFormId + '_' + opts.simpleFormWidgetId;
				opts.ref = ref;
				
				this.addFormWidget( w, opts );
			}
		}

	}
	
	

	renderWidgetItemsList() {
		if (this.widgets == null || this.widgets.length == 0)
			return;
		
		for(let i in this.widgets) {
			let w = this.widgets[i];
			
			let a = document.createElement('a');
			a.widget = w;
			a.innerText = w.description;
			a.onclick = (evt) => { this.addFormWidget_Click( evt ); }
			
			document.querySelector('.widget-list').appendChild( a );
		}
	}
	
	async renderFormList() {
		
		let r = await postJson('/service/simpleforms/list.do', {
			a: 'listActive'
		});
		
		let json = await r.json();
		
		
		if ( json.forms.length == 0 )
			return;
		
		let c = $('.work-editor .form-list');
		c.append('<span class="title">'+_('Forms')+'</span>');
		
		for(let i=0; i < json.forms.length; i++) {
			let f = json.forms[i];
			
			let a = document.createElement('a');
			a.innerText = f.name;
			a.form = f;
			a.addEventListener('click', (evt) => {
				this.addFormWidgets_Click( f );
			});
			c.append(a);
		}
	}
	
	addFormWidgets_Click( form, opts ) {
		opts = opts ? opts : {};
		console.log('form', form);
		
		for(let i=0; i < form.widgets.length; i++) {
			let w = form.widgets[i];
			w.class = this.getWidget( w.widgetType ).class;
			
			let ref_key = 'sfw_'+form.simpleFormId + '_' + w.simpleFormWidgetId;
			
			let existingWidget = this.widgetByRef( ref_key );
			if (existingWidget) {
				$(existingWidget).fadeOut(200).fadeIn(200);
			}
			else {
				this.addFormWidget( w, { ref: ref_key });
			}
		}
	}
	
	widgetByRef( ref_key ) {
		let entries = document.querySelectorAll('.widget-entry');
		for(let i=0; i < entries.length; i++) {
			if ( entries[i].widget && entries[i].widget.ref && entries[i].widget.ref == ref_key )
				return entries[i];
		}
		
		return null;
	}
	



	getWidget( widgetName ) {
		for(let i=0; i < this.widgets.length; i++) {
			if (this.widgets[i].name == widgetName) {
				return this.widgets[i];
			}
		}
		
		console.error('getWidget(), widget not found', widgetName);
		
		return null;
	}


	renderWidgets() {
		if ( !this.workOrder.widgets || this.workOrder.widgets.length == 0 ){
			return;
		}
		
		for(let i=0; i < this.workOrder.widgets.length; i++) {
			let w = this.workOrder.widgets[i];
			
			let o = this.getWidget( w.widgetType );
			
			this.addFormWidget( o, w, { showProps: false });
		}
		
		
	}
	
	
	gotoLocation_Click() {
		
		let lt = trim ( document.querySelector('input[name=locationText]').value );
		if (lt == '') {
			showAlert( _('Error'), _('No location set') );
			return;
		}
		
		
		window.open('http://maps.google.nl/?q=' + encodeURIComponent(lt), '_blank');
		
		
	}

	addFormWidget_Click( evt ) {
		let w = evt.target.widget;
		this.addFormWidget(w);
	}


	addFormWidget( w, widgetOpts, opts ) {
		$('.sample-empty-text').remove();
		
		widgetOpts = widgetOpts ? widgetOpts : {};
		opts = opts ? opts : {};
		
		let o = Reflect.construct( w.class, [widgetOpts] );
		
		let wc = document.createElement('div');
		wc.className = 'widget-entry';
		wc.widget = o;
		wc.addEventListener('click', (evt) => {
			// trash clicked? => skip
			if ( $(evt.target).hasClass('trash') ) return;
			
			this.showProperties( o );
		});
		
		let label = document.createElement('div');
		label.className = 'top-bar';
		
		let topbarActions = document.createElement('div');
		topbarActions.className = 'top-bar-actions';
		
		appendHtml( topbarActions, ' <span class="widget-report-status"></span> ' );
		appendHtml( topbarActions, ' <a class="fa trash fa-trash"></a> ' );
//		appendHtml( label, ' <a class="fa edit fa-pencil"></a> ' + w.description );
//		label.querySelector('a.edit').onclick = (evt) => {
//			this.showProperties( o );
//		};

		label.appendChild( topbarActions );

		label.querySelector('a.trash').onclick = (evt) => {
			$('.widget-properties').empty();
		
			$(wc).remove();
		};
		
		wc.appendChild( label );
		
		// sort handle
		let sorthandle = document.createElement('div');
		sorthandle.className = 'sort-handle';
		wc.appendChild( sorthandle );
				
		// widget itself
		let d = document.createElement('div');
		d.className = 'widget-preview';
		
		o.renderEdit(d);
		o.setCallbackPropertyChanged(() => {
			this.updateReportStatus(o, wc);
		});
		
		wc.appendChild(d);
		
		document.querySelector('.wo-container').appendChild( wc );
		
		this.updateReportStatus(o, wc);
		
		// open property editor
		if (typeof opts.showProps == 'undefined' || opts.showProps == true)
			this.showProperties( o );
	}
	
	updateReportStatus( widgetObject, htmlContainer ) {
		let c = $(htmlContainer).find('.widget-report-status');
		c.empty();

		if ( widgetObject.reportStatus == 'inprogress') {
			c.append('<span class="fa-solid fa-arrows-rotate"></span>');
			
			c.attr('class', 'widget-report-status report-status-inprogress');
		}
		else if ( widgetObject.reportStatus == 'cancelled') {
			c.append('<span class="fa-solid fa-xmark"></span>');
			
			c.attr('class', 'widget-report-status report-status-cancelled');
		}
		else if ( widgetObject.reportStatus == 'processed') {
			c.append('<span class="fa-solid fa-check"></span>');
			
			c.attr('class', 'widget-report-status report-status-processed');
		}
		else {
			c.attr('class', 'widget-report-status report-status-open');
		}

	}


	showProperties( widget ) {
		// already rendered? => skip
		let curnode = document.querySelector('.widget-properties > .sf-props');
		if (curnode && curnode.widget == widget)
			return;
		
		$('.widget-entry').removeClass('selected');
		
		$(widget.container).parent().addClass('selected');
		
//		console.log('render...', widget);
		
		let t = new EzTemplate('.widget-properties');
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		t.setVar('sfw', widget);
		t.render();
		
		widget.renderProps();
		
		// set widget
		let node = document.querySelector('.widget-properties > .sf-props');
		node.widget = widget;
	}


	
	
	back_Click() {
		gotoRoute( '/work/' );
	}
	
	addFile_Click() {
		let p = new FileUploadPickPopup();
		
		p.setCallbackPick((db_file_id, db_file) => {
			this.addFile( db_file );
			this.renderFiles();
		});
		
		p.show();
	}
	
	addFile( db_file ) {
		let newList = [];
		for(let i=0; i < this.files.length; i++) {
			if (this.files[i].dbFileId == db_file.dbFileId)
				continue;
			newList.push( this.files[i] );
		}
		newList.push( db_file );
		this.files = newList;
	}
	
	getFileAnchor( dbFileId ) {
		let n = null;
		$('.files-container .file-list .db-file').each((i, node) => {
			if ( node.file.dbFileId == dbFileId ) {
				n = node;
				return false;
			}
		});
		
		return n;
	}
	
	renderFiles() {
		for(let i=0; i < this.files.length; i++) {
			let f = this.files[i];
			
			// check if file is already in list
			let prevanch = this.getFileAnchor( f.dbFileId );
			if (prevanch != null)
				continue;
			
			let a = document.createElement('a');
			a.className = 'db-file';
			a.file = f;
			a.onclick = () => {
				this.showSampleFile( f );
			};
			
			let img = document.createElement('img');
			img.src = appUrl('/service/files.do?a=sample&id=' + f.dbFileId);
			let img_container = document.createElement('div');
			img_container.append(img);
			a.appendChild( img_container );
			
			let txt = document.createElement('div');
			txt.className='filename';
			txt.innerText = truncate( f.originalFilename, 50 );
			a.appendChild(txt);
			
			$('.files-container .file-list').append( a );
		}
	}
	
	showSampleFile(f) {
		console.log(f);
		
		let p = new SampleFilePopup( f );
		p.setCallbackRemoveFile((f) => {
			let a = this.getFileAnchor( f.dbFileId );
			
			this.files = this.files.filter((f2) => {
				return f2.dbFileId == f.dbFileId ? false : true;
			})
			
			$(a).remove();
		});
		p.showPopup();
	}
	
	
	
	async save_Click() {
		let d = {};

		d.workOrderId      = this.workOrder.workOrderId;
		d.customerId       = $('.work-head input[name=customerId]').val();
		d.userId           = $('.work-head input[name=userId]').val();
		d.description      = $('.work-head input[name=description]').val();
		d.locationText     = $('.work-head input[name=locationText]').val();
		d.orderDate        = $('.work-head input[name=orderDate]').val();
		d.status           = $('.work-head select[name=status]').val();
		

		d.widgets = [];
		let entries = document.querySelectorAll('.widget-entry');
		for(let i=0; i < entries.length; i++) {
			let w = entries[i].widget;
			d.widgets.push( w.getData() );
		}
		
		d.files = this.files;
		
		d.permissions = this.permissionsWidget.getPermissions();

		showLoadingForm('.work-edit-widget');

		d.a = 'save';
		let r = await postJson('/service/work/edit.do', d);
		let json = await r.json();


		if (json.error) {
			reportUserError( 'Error: ' + json.message );
		}
		else {
			reportUserMessage( _('Changes saved') );
			replaceRoute('/work/edit/?id=' + json.workOrderId);
		}

		hideLoadingForm('.work-edit-widget');
	}
	
	
	delete_Click() {
		
		showConfirmation( _('Delete'), _('Are you sure to delete this work order?'), async () => {
			showLoadingForm('.work-edit-widget');
			
			let r = await postUrl('/service/work/edit.do', {
				a: 'delete',
				workOrderId: this.workOrder.workOrderId
			});
			
			
			let json = await r.json();
			
			if (json.success) {
				gotoRoute( '/work/' );
				reportUserMessage(_('Work order deleted'));
			}
			else {
				reportUserError('Error: ' + json.message);
			}
			
			removeLoadingForm( '.work-edit-widget' );
		});
	}
	
	
	
	
	
}


