

export class WorkListWidget {
	
	tpl = `
		<div class="work-list-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.templates_Click" class="fa fa-sheet-plastic"></a>
					
					<a [onclick]="widget.add_Click" class="fa fa-plus"></a>
				</div>
				<h1>{{_('Work order list')}}</h1>
			</div>
			
			<div class="search-options-v1">
				<div class="search-row">
					<ez-customer name="cid" [value]="cid" [valueText]="customerName" label="{{_('Relation')}}"></ez-customer>
					
					<ez-user name="uid" [value]="uid" label="{{_('User')}}"></ez-user>
				</div>
				
				<div class="search-row">
					<ez-date name="sd" [value]="sd" label="{{_('From')}}"></ez-date>
					<ez-date name="ed" [value]="ed" label="{{_('Till')}}"></ez-date>
					
					<ez-select name="status" [value]="status" label="{{_('Status')}}">
						<option value="">{{_('Make your choice')}}</option>
						<option value="open">{{_('open')}}</option>
						<option value="inprogress">{{_('inprogress')}}</option>
						<option value="cancelled">{{_('Cancelled')}}</option>
						<option value="done">{{_('Done')}}</option>
					</ez-select>
				</div>
				<div class="search-row">
					<ez-text class="q-search" name="q" [value]="q" label="" placeholder="{{_('Search...')}}"></ez-text>
				</div>
				
				<a [onclick]="widget.reset_Click">{{_('Reset')}} &gt;</a>
			</div>
			
			
			<hr/>
	
			<div ez-subtemplate="wolist">
				<div ez-if="workorders == null">
					Loading...
				</div>
				
				<div ez-if="workorders != null">
				
					<div class="div-table tbl-work-list tbl-r2b-list">
						<div class="header">
							<div class="col-id">#</div>
							<div class="col-customer-name">{{_('Relation name')}}</div>
							<div class="col-description">{{_('Description')}}</div>
							<div class="col-date">{{_('Date')}}</div>
							<div class="col-username">{{_('Username')}}</div>
							<div class="col-status">{{_('Status')}}</div>
							<div class="col-edited">{{_('Edited')}}</div>
						</div>
						
						<div ez-for="workorders" ez-item="wo">
							<div class="record" [onclick]="widget.work_Click" [wo]="wo">
								<div class="col-id">{{wo.workOrderId}}</div>
								<div class="col-customer-name">{{ifnull(wo.customerName, '&nbsp;')}}</div>
								<div class="col-description">{{wo.description}}</div>
								<div class="col-date">{{ifempty(format_datetime_minutes(wo.orderDate, {dmy:true, showZero: false}), '&nbsp;')}}</div>
								<div class="col-username">{{ifnull(wo.username, '&nbsp;')}}</div>
								<div class="col-status">{{_('reportStatus.'+wo.status)}}</div>
								<div class="col-edited">{{format_datetime_minutes(wo.edited, {dmy: true})}}</div>
							</div>
						</div>
						<div ez-if="workorders.length == 0">
							<div class="no-results-found">
								{{_('No results found')}}
							</div>
						</div>
					</div>
					
					<ez-pager></ez-pager>
				</div>
			</div>
		</div>
	`;
	
	
	container = null;
	
	searchAbortController = null;
	
	workorders = null;
	
	lastResponse = null;
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.search();
	}
	
	render() {
		let urlParams = getUrlParams();
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('workorders', this.workorders);
		
		if (urlParams['cid'])    eztpl.setVar('cid', urlParams['cid']);
		if (urlParams['uid'])    eztpl.setVar('uid', urlParams['uid']);
		if (urlParams['sd'])     eztpl.setVar('sd', urlParams['sd']);
		if (urlParams['ed'])     eztpl.setVar('ed', urlParams['ed']);
		if (urlParams['status']) eztpl.setVar('status', urlParams['status']);
		if (urlParams['q'])      eztpl.setVar('q', urlParams['q']);
		if (urlParams['pno']) {
			let pno = parseInt(urlParams['pno']);
			if (isNaN(pno) == false && pno > 0) this.pageNo = pno;
		}
		
		eztpl.render();
		
		
		$('.search-options-v1').find('ez-customer, ez-user, input, select').on('change dp.change', () => {
			this.doSearch();
		});
	}
	
	
	templates_Click() {
		gotoRoute( '/simpleforms/' );
	}
	
	add_Click() {
		gotoRoute( '/work/edit/' );
	}
	
	
	
	work_Click( evt, obj ) {
		let wo = obj.wo;
		
		gotoRoute( '/work/edit/?id=' + wo.workOrderId );
	}
	
	
	getSearchParams() {
		let frm = $('.search-options-v1');
		
		let d = {};
		d.cid    = frm.find('input[name=cid]').val();
		d.uid    = frm.find('input[name=uid]').val();
		d.sd     = frm.find('input[name=sd]').val();
		d.ed     = frm.find('input[name=ed]').val();
		d.status = frm.find('select[name=status]').val();
		d.q      = $.trim( frm.find('.q-search input[type=text]').val() );
		
		return d;
	}
	
	
	updateUri() {
		let params = this.getSearchParams();
		
		params['pno'] = this.pageNo;

		let url = '';
		for(let i in params) {
			if (url != '')
				url += '&';
			url += i + '=' + encodeURIComponent( params[i] );
		}

		url = appUrl('/work/') + '?' + url;

		window.history.replaceState({}, null, url);
	}
	
	doSearch() {
		this.pageNo = 0;
		
		this.updateUri();
		
		this.search();
	}
	
	
	async search( opts ) {
		opts = opts ?? {};
		
		if (this.searchAbortController != null) {
			this.searchAbortController.abort();
		}
		
		this.searchAbortController = new AbortController();
		let data = this.getSearchParams();
//		data.q = this.q;
		data.pageNo = this.pageNo;
		
		postUrl(
			'/service/work/list.do'
			, data
			, {
				signal: this.searchAbortController.signal
			}
		)
		.then(async (data) => {
			let resp = await data.json();
			
			console.log( resp );
			
			if (resp.error) {
				showErrorWidget( resp );
				return;
			}
			
			this.lastResponse = resp;
			
			let eztpl = $('[ez-subtemplate=wolist]').get(0).eztemplate;
			
//			eztpl.setObject('widget', this);
			eztpl.setVar('workorders', resp.workOrders);
			eztpl.setVar('response', resp);
			
			eztpl.render();
		})
		.catch( showErrorWidget )
	}
	
	selectPage( pageNo ) {
		this.pageNo = pageNo;
		
		this.updateUri();
		
		this.search();
	}
	
	
	reset_Click() {
		gotoRoute( '/work/' );
	}
	
	
}

