


export class WorkTabWidget {
	
	
	
	tpl = `
		
		<div class="action-box">
			<span><a [onclick]="widget.addWorkOrder_Click">{{_('Add work order')}}</a></span>
		</div>
		
		<table class="table">
			<thead>
				<tr>
					<th style="width: 40px;">#</th>
					<th>{{_('Description')}}</th>
					<th style="width: 130px;">{{_('Date')}}</th>
					<th style="width: 120px;">{{_('Username')}}</th>
					<th style="width: 80px;">{{_('Status')}}</th>
					<th style="width: 150px;">{{_('Edited')}}</th>
				</tr>
			</thead>
			<tbody ez-for="workOrders" ez-item="wo" id="wot-listing">
				<tr [onclick]="widget.wo_Click" [wo]="wo" class="pointer">
					<td>{{wo.workOrderId}}</td>
					<td>{{wo.description}}</td>
					<td>{{format_datetime_minutes(wo.orderDate, {dmy:true, showZero: false})}}</td>
					<td>{{ifnull(wo.username, '&nbsp;')}}</td>
					<td>{{_(wo.status)}}</td>
					<td>{{format_datetime(wo.edited, {dmy: true})}}</td>
				</tr>
			</tbody>
			<tr id="rec-feedback-work">
				<td colspan="100%">Loading...</td>
			</tr>
		</table>
	`;
	
	container = null;
	customerId = null;
	
	loading = false;
	
	start = 0;
	lastResponse = null;
	
	constructor() {
		this.customerId = $('#frmCustomer input[name=customerId]').val();
		
	}
	
	
	render() {
		if (!this.customerId) {
			console.error('WorkTabWidget.render, customerId not set');
			return;
		}
		
		this.addTab();
		
		this.renderContent();
	}
	
	
	async loadData() {
		
		if (this.loading) return;
		
		this.loading = true;
		
		
		let r = await postJson('/service/work/list.do', {
			cid: this.customerId,
			start: this.start
		});
		
		let json = await r.json();
		
		
		// set next start pos
		this.start = json.start + json.pageSize;
		
		
		document.querySelector('button.nav-link#work-tab').innerText = _('Work orders') + ' (' + json.rowCount + ')';
		
		
		let tr_f = document.getElementById('rec-feedback-work');
		if (json.rowCount == 0) {
			tr_f.className = 'no-results-found';
			tr_f.querySelector('td').innerText = _('No results found');
			return;
		}
		else if (json.rowCount > this.start) {
			tr_f.querySelector('td').innerHTML = '';
			
			// Load more-text
			let anch = document.createElement('a');
			anch.className = 'load-more';
			anch.innerText = _('Load more...');
			anch.addEventListener('click', () => {
				this.loadData();
			});
			tr_f.querySelector('td').appendChild( anch );
		}
		else {
			tr_f.parentNode.removeChild( tr_f );
		}
		
		
		
		// add records
		let eztpl = document.querySelector('#wot-listing').eztemplate;
		for(let i=0; i < json.workOrders.length; i++) {
			let wo = json.workOrders[i];
			
			eztpl.createRecord( wo );
		}
		
		
		// load-more
		
		
		
//		console.log(eztpl);
		
		this.loading = false;
		
	}
	
	
	
	
	addTab() {
		let li = document.createElement('li');
		li.className = 'nav-item';
		li.setAttribute('role', 'presentation');
		
		let btn = document.createElement('button');
		btn.className = 'nav-link';
		btn.setAttribute('id', 'work-tab');
		btn.setAttribute('data-bs-toggle', 'tab');
		btn.setAttribute('data-bs-target', '#customer-workorders');
		btn.setAttribute('type', 'button');
		btn.setAttribute('role', 'tab');
		btn.setAttribute('aria-controls', 'workorders-tab');
		btn.setAttribute('aria-selected', 'false');
		btn.innerText = _('Work orders');
		
		li.appendChild( btn );
		
		
		insertNodeAtPos( '#customerTabs > li', 1, li );
	}
	
	
	renderContent() {
		if (this.container == null) {
			let pane = document.createElement('div');
			pane.className = 'tab-pane fade';
			pane.setAttribute('id', 'customer-workorders');
			pane.setAttribute('role', 'tabpanel');
			pane.setAttribute('aria-labelledby', 'workorders-tab');
			document.getElementById('customerTabsContent').appendChild( pane );
			
			this.container = pane;
		}
		
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		
		eztpl.setVar('loading', this.loading);
		
		eztpl.render();
		
		this.loadData();
	}
	
	
	wo_Click( evt, obj ) {
		let wo = obj.wo;
		
		gotoRoute('/work/edit/?id='+wo.workOrderId);
	}
	
	
	
	addWorkOrder_Click() {
		gotoRoute('/work/edit/?selected_cid='+this.customerId);
	}
	
	
	
}


