
import { listSimpleFormWidgets } from './widgets/helper.js';



export class SimpleFormEditWidget {
	
	tpl = `
		<div class="simple-form-edit-widget">
			<div class="page-header">
				<div class="toolbox">
					<a [onclick]="widget.back_Click" class="fa fa-chevron-circle-left"></a>
					
					<span ez-if="isNew == false">
						<a [onclick]="widget.delete_Click" class="fa fa-trash"></a>
					</span>
					
					<a [onclick]="widget.save_Click" class="fa fa-save"></a>
				</div>
				<h1>{{isNew ? _('Add form') : _('Edit form')}}</h1>
			</div>
			
			<div ez-if="loading == true">
				<img src="/static/img/ajax-loader-small.gif" /> Loading..
			</div>
			
			<div ez-if="loading == false">
				<div class="simple-form-head">
					<ez-checkbox label="{{_('Active')}}" name="active" [checked]="form.active"></ez-checkbox>
					
					<ez-checkbox label="{{_('Default selected')}}" name="defaultSelected" [checked]="form.defaultSelected"></ez-checkbox>
					
					<ez-text label="{{_('Form name')}}" name="name" [value]="form.name"></ez-text>
				</div>
				
				<hr/>
				
				<div class="widget-editor">
					<div class="widget-list"></div>
					
					<div class="form-sample">
						<div class="sample-empty-text">{{_('Add a widget')}}</div>
					</div>
					
					<div class="widget-properties"></div>
				</div>
			</div>
		</div>	
	`;
	
	tplProps = `
		<div class="sf-props">
		
			<div class="title">
				{{sfw.widgetDescription}}
			</div>
		
			<div class="property-list"></div>
			
		</div>
	`;
	
	
	
	isNew = true;
	container = null;
	loading = false;
	widgets = [];
	
	form = {
		simpleFormId: 0,
		name: '',
		defaultSelected: false,
		active: true
	}
	
	
	init(e) {
		this.container = e;
		
		this.widgets = listSimpleFormWidgets();
		
		let id = getUrlParam('id');
		if (id) {
			this.loading = true;
			this.loadForm( id );
		}
		
		this.render();
	}
	
	
	
	getWidget( widgetName ) {
		for(let i=0; i < this.widgets.length; i++) {
			if (this.widgets[i].name == widgetName) {
				return this.widgets[i];
			}
		}
		
		console.error('getWidget(), widget not found', widgetName);
		
		return null;
	}
	
	
	
	async loadForm( id ) {
		
		let r = await postUrl('/service/simpleforms/edit.do', {
			a: 'view',
			id: id
		});
		
		let json = await r.json();
		this.form = json.form;
		
		this.loading = false;
		this.isNew = false;
		this.render();
	}
	
	
	delete_Click() {
		
		showConfirmation(_('Delete'), _('Are you sure to delete this form?'), async () => {
			showLoadingForm('.simple-form-edit-widget');
			
			await postUrl('/service/simpleforms/edit.do', {
				a: 'delete',
				simpleFormId: this.form.simpleFormId
			});
			
			reportUserMessage(_('Form deleted'));
			gotoRoute( '/simpleforms/' );
		});
		
	}
	
	
	back_Click() {
		gotoRoute( '/simpleforms/' );
	}
	
	async save_Click() {
		let d = {};
		
		d.simpleFormId = this.form.simpleFormId;
		d.active = $('.simple-form-head input[name=active]').prop('checked') ? 1 : 0;
		d.defaultSelected = $('.simple-form-head input[name=defaultSelected]').prop('checked') ? 1 : 0;
		d.name = $('.simple-form-head input[name=name]').val();
		
		d.widgets = [];
		let entries = document.querySelectorAll('.widget-entry');
		for(let i=0; i < entries.length; i++) {
			let w = entries[i].widget;
			d.widgets.push( w.getData() );
		}
		
		console.log('save thing', d);
		
		showLoadingForm('.simple-form-edit-widget');
		
		d.a = 'save';
		let r = await postJson('/service/simpleforms/edit.do', d);
		let json = await r.json();
		
		
		if (json.error) {
			reportUserError( 'Error: ' + json.message );
		}
		else {
			reportUserMessage( _('Changes saved') );
			gotoRoute('/simpleforms/edit/?id='+json.simpleFormId);
		}
		
		hideLoadingForm('.simple-form-edit-widget');
	}
	
	
	renderFormList() {
		
		for(let i in this.widgets) {
			let w = this.widgets[i];
			
			let a = document.createElement('a');
			a.widget = w;
			if (w.descriptionHtml)
				a.innerHTML  = w.descriptionHtml;
			else
				a.innerText = w.description;
			a.onclick = (evt) => { this.addFormWidget_Click( evt, a ); }
			
			document.querySelector('.widget-list').appendChild( a );
		}
	}
	
	
	addFormWidget_Click( evt, anchor ) {
		let w = anchor.widget;
		
		this.addFormWidget(w);
	}
	
	
	addFormWidget( w, widgetOpts, opts ) {
		$('.sample-empty-text').remove();
		
		widgetOpts = widgetOpts ? widgetOpts : {};
		opts = opts ? opts : {};
		let o = Reflect.construct( w.class, [widgetOpts] );
		
		let wc = document.createElement('div');
		wc.className = 'widget-entry';
		wc.widget = o;
		wc.addEventListener('click', () => {
			this.showProperties( o );
		});
		
		
		let label = document.createElement('div');
		label.className = 'top-bar';
		
		let topbarActions = document.createElement('div');
		topbarActions.className = 'top-bar-actions';
		
		appendHtml( topbarActions, ' <a class="fa trash fa-trash"></a> ' );
//		appendHtml( label, ' <a class="fa edit fa-pencil"></a> ' + w.description );
//		label.querySelector('a.edit').onclick = (evt) => {
//			this.showProperties( o );
//		};
		label.appendChild( topbarActions );
		
		label.querySelector('a.trash').onclick = (evt) => {
			wc.widget.removed = true;
			
			$('.widget-properties').empty();
			$(wc).remove();
		};
		
		wc.appendChild( label );
		
		// sort handle
		let sorthandle = document.createElement('div');
		sorthandle.className = 'sort-handle';
		wc.appendChild( sorthandle );
				
		// widget itself
		let d = document.createElement('div');
		d.className = 'widget-preview';
		
		o.renderEdit(d);
		wc.appendChild(d);
		
		document.querySelector('.form-sample').appendChild( wc );
		
		// open property editor
		if (typeof opts.showProps == 'undefined' || opts.showProps == true)
			this.showProperties( o );
	}
	
	
	showProperties( widget ) {
		
		if (widget.removed === true)
			return;
		
		// already rendered? => skip
		let curnode = document.querySelector('.widget-properties > .sf-props');
		if (curnode && curnode.widget == widget)
			return;
		
		$('.widget-entry').removeClass('selected');
		
		$(widget.container).parent().addClass('selected');
		
		let t = new EzTemplate('.widget-properties');
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		t.setVar('sfw', widget);
		t.render();
		
		widget.renderProps();
		
//		$('.widget-properties').find('input[type=text], input[type=number]').first().focus();

		// set widget
		let node = document.querySelector('.widget-properties > .sf-props');
		node.widget = widget;
	}
	
	
	
	renderWidgets() {
		if ( !this.form.widgets || this.form.widgets.length == 0 ){
			return;
		}
		
		for(let i=0; i < this.form.widgets.length; i++) {
			let w = this.form.widgets[i];
			
			let o = this.getWidget( w.widgetType );
			
			this.addFormWidget( o, w, { showProps: false });
		}
		
		
	}
	
	
	render() {
		
		let eztpl = new EzTemplate(this.container);
		eztpl.loadHtml(this.tpl);
		eztpl.setObject('widget', this);
		eztpl.setVar('isNew', this.isNew);
		eztpl.setVar('loading', this.loading);
		
		eztpl.setVar('form', this.form);
		
		eztpl.render();
		
		if (this.loading) return;
		
		$('.form-sample').sortable({
			axis: 'y',
			handle: '.sort-handle'
		});
		
		this.renderFormList();
		
		this.renderWidgets();
	}
	
	
}


