
export class SimpleFormListWidget {
	
	tpl = `
	<div class="simple-form-list-widget">
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/work/')}}" class="fa fa-chevron-circle-left"></a>
				
				<a href="{{appUrl('/simpleforms/edit/')}}" class="fa fa-plus"></a>
			</div>
			<h1>{{_('Forms')}}</h1>
		</div>
		
		<div ez-subtemplate="formlist">
			<div ez-if="forms == null">
				Loading...
			</div>
			
			<div ez-if="forms != null">
			
				<div class="div-table tbl-simple-forms">
					<div class="header">
						<div class="col-sort-handle"></div>
						<div class="col-name">{{_('Name')}}</div>
						<div class="col-default-selected">{{_('Default selected')}}</div>
						<div class="col-active">{{_('Active')}}</div>
						<div class="col-edited">{{_('Edited')}}</div>
					</div>
					
					<div ez-for="forms" ez-item="f">
						<div class="record" [onclick]="widget.form_Click" [form]="f">
							<div class="col-sort-handle"></div>
							<div class="col-name">{{f.name}}</div>
							<div class="col-default-selected">{{f.defaultSelected ? _('Yes') : _('No')}}</div>
							<div class="col-active">{{f.active ? _('Yes') : _('No')}}</div>
							<div class="col-edited">{{format_datetime(f.edited, {dmy: true})}}</div>
						</div>
					</div>
					<div ez-if="forms.length == 0">
						<div class="record no-results-found">
							{{_('No results found')}}
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	`;
	
	
	container = null;
	
	pageNo = 0;
	response = null;
	forms = null;
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.search();
	}
	
	
	
	form_Click( evt, obj ) {
		if ($(evt.target).hasClass('col-sort-handle') || $(evt.target).closest('.col-sort-handle').length > 0) {
			return;
		}
		
		let form = obj.form;
		gotoRoute('/simpleforms/edit/?id=' + form.simpleFormId);
	}
	
	async search() {
		
		let r = await postJson('/service/simpleforms/list.do', {
			pageNo: this.pageNo
		});
		let json = await r.json();
		
		this.response = json;
		this.forms = json.forms;
		
		this.render();
	}
	
	selectPage( pageNo ) {
		this.pageNo = pageNo;
		this.search();
	}

	
	render() {
		let eztpl = new EzTemplate(this.container);
		eztpl.loadHtml(this.tpl);
		eztpl.setObject('widget', this);
		eztpl.setVar('response', this.response);
		eztpl.setVar('forms', this.forms);
				
		eztpl.render();
		
		$('[ez-for=forms]').sortable({
			axis: 'y',
			handle: '.col-sort-handle',
			update: () => {
				let ids = [];
				$('[ez-for=forms] .record').each(function(ix, node) {
					ids.push( node.form.simpleFormId );
				});
				
				postUrl('/service/simpleforms/list.do', {
					a: 'updateSort',
					ids: ids.join(',')
				}).then(() => {
					showToastMessage( _('Changes saved') );
				});
			}
		});
		
	}
	
	
}


