
export class SFCheckboxWidget {
	
	static sf_counter = 1;

	widgetDescription = _('Checkbox');
	
	tpl = `
		<div class="sf-checkbox-widget">
			<label for="sfcb_{{uid}}" class="checkbox-label" style="display: block;">{{label??'&nbsp;'}}</label>
			<input type="checkbox"
						id="sfcb_{{uid}}"
						name="{{name}}"
						[onchange]="widget.value_Change"
						[checked]="value" />
		</div>
	`;
	
	tplProps = `
		<div class="sf-checkbox-props">
			<ez-text label="Label"
						name="label"
						[onkeyup]="widget.label_Change" 
						[value]="label"></ez-text>
		</div>
	`;
	
	
	container = null;
	
	uid = null;
	
	ref = '';
	name = '';
	label = _('Checkbox...');
	value = false;
	
	callback_propertyChanged = null;
	
	
	constructor( opts ) {
		opts = opts ? opts : {};
		this.name = opts.name;
		
		if (opts.ref) this.ref = opts.ref;
		
		if (opts.widgetLabel)
			this.label = opts.widgetLabel;
		if (opts.widgetValue1 && opts.widgetValue1 == '1')
			this.value = true;
		
		let props = parse_json( opts.properties );
		if (props) {
			if (props.ref) this.ref = props.ref;
		}
		
		this.uid = SFCheckboxWidget.sf_counter++;
	}
	
	setCallbackPropertyChanged( c ) {
		this.callback_propertyChanged = c;
	}
	
	getData() {
		let d = {};
		d['type'] = 'SFCheckboxWidget';
		d['ref'] = this.ref;
		d['name'] = this.name;
		d['label'] = this.label;
		d['value1'] = $(this.container).find('input[type=checkbox]').prop('checked') ? 1 : 0;
		
		return d;
	}
	
	
	renderEdit( container ) {
		return this.render(container);
	}
	
	render( container ) {
		this.container = container;
		
		let eztpl = new EzTemplate( container );
		eztpl.loadHtml(this.tpl);
		eztpl.setObject('widget', this);
		eztpl.setVar('name', this.name);
		eztpl.setVar('label', this.label);
		eztpl.setVar('value', this.value);
		eztpl.setVar('uid', this.uid);
		
		eztpl.render();
	}
	
	
	label_Change() {
		let l = $('.sf-checkbox-props input[name=label]').val();
		
		this.label = l;
		$(this.container).find('.checkbox-label').text( l );
	}
	
	value_Change() {
		let v = $(this.container).find('input[name=name]').prop('checked');
		
		this.value = v;
	}
	
	
	renderProps() {
		let t = new EzTemplate( '.sf-props .property-list' );
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		
//		t.setVar('name', this.name);
		t.setVar('label', this.label);
		t.setVar('value', this.value);
		
		t.render();
	}
	
}


