
export class SFHourLabelWidget {
	
	static sf_counter = 1;

	widgetDescription = _('Hours');
	
	
	tpl = `
		<div class="sf-hour-label-widget">
			<label for="sfh_{{uid}}" class="sf-hour-label" style="display: block;">{{label??'&nbsp;'}}</label>
			<input type="number" 
					id="sfh_{{uid}}" 
					class="input-hour-value"
					name="{{name+'_value'}}"
					[placeholder]="placeholderHour"
					[value]="value" />
		</div>
	`;
	
	tplProps = `
		<div class="sf-hour-label-props">
			<ez-text label="{{_('Label')}}"
						name="label"
						[onkeyup]="widget.label_Keyup" 
						[onchange]="widget.label_Change"
						[value]="label"></ez-text>
			<ez-text label="{{_('Placeholder hours')}}"
						name="placeholderPropHour"
						[onkeyup]="widget.placeholderHour_Keyup" 
						[onchange]="widget.placeholderHour_Change"
						[value]="placeholderPropHour"></ez-text>

			<ez-select name="reportStatus" 
						label="{{_('Report status')}}"
						[onchange]="widget.reportStatus_Change" 
						[value]="reportStatus">
				<option value="open">{{_('reportStatus.open')}}</option>
				<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
				<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
				<option value="processed">{{_('reportStatus.processed')}}</option>
			</ez-select>
		</div>
	`;

	
	container = null;
	
	uid = null;
	
	ref = '';
	
	name = '';
	label = _('Hours...');
	value = '';
	reportStatus = 'open';
	placeholderHour = '0';
	
	callback_propertyChanged = null
	
	constructor( opts ) {
		opts = opts ? opts : {};
		this.name = opts.name;
		
		if (opts.ref) this.ref = opts.ref;
		
		if (opts.widgetLabel)
			this.label = opts.widgetLabel;
		if (opts.widgetValue1)
			this.value = opts.widgetValue1;
		
		if (opts.reportStatus)
			this.reportStatus = opts.reportStatus;
		
		let props = parse_json( opts.properties );
		if (props) {
			this.placeholderHour = props.placeholderHour;
			if (props.ref) this.ref = props.ref;
		}
		
		this.uid = SFHourLabelWidget.sf_counter++;
	}
	
	
	setCallbackPropertyChanged( c ) {
		this.callback_propertyChanged = c;
	}

	
	
	getData() {
		this.value = trim( $(this.container).find('.input-hour-value').val() );

		let d = {};
		d['type'] = 'SFHourLabelWidget';
		d['ref'] = this.ref;
		d['name'] = this.name;
		d['label'] = this.label;
		d['value1'] = this.value;
		d['placeholderHour'] = this.placeholderHour;
		d['reportStatus'] = this.reportStatus;
		
		return d;
	}
	
	
	renderEdit( container ) {
		return this.render(container);
	}
	
	render( container ) {
		this.container = container;
		
		let eztpl = new EzTemplate( container );
		eztpl.loadHtml(this.tpl);
		eztpl.setVar('name', this.name);
		eztpl.setVar('label', this.label);
		eztpl.setVar('value', this.value);
		eztpl.setVar('placeholderHour', this.placeholderHour);
		eztpl.setVar('uid', this.uid);
		
		eztpl.render();
	}
	
	
	
	label_Keyup(evt, obj) {
		let label = trim( $(obj).find('input[name=label]').val() );
		this.label = label;
		$(this.container).find('.sf-hour-label').text( label );
	}
	
	label_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	placeholderHour_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropHour]').val() );
		this.placeholderHour = placeholderText;
		$(this.container).find('.input-hour-value').attr('placeholder', placeholderText);
	}
	placeholderHour_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
		
	reportStatus_Change( evt, obj ) {
		this.reportStatus = $('.sf-hour-label-props select[name=reportStatus]').val();
		
		if (this.callback_propertyChanged != null)
			this.callback_propertyChanged();
	}

	
	renderProps() {
		let t = new EzTemplate( '.sf-props .property-list' );
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		
		t.setVar('label', this.label);
		t.setVar('placeholderPropHour', this.placeholderHour);
		t.setVar('reportStatus', this.reportStatus);
		
		t.render();
	}
	
		
}

