

export class SFHourWidget {
	
	widgetDescription = _('Hours');
	
	
	tpl = `
		<div class="sf-hour-widget">
			<input type="text" 
					class="input-hour-description"
					[placeholder]="placeholderDescription"
					[onchange]="widget.hourDescription_Change" 
					name="{{name}}"
					[value]="label" />
			<input type="number" 
					class="input-hour-value"
					name="{{name+'_value'}}"
					[placeholder]="placeholderHour"
					[value]="value" />
		</div>
	`;
	
	tplProps = `
		<div class="sf-hour-props">
			<ez-text label="{{_('Placeholder description')}}"
						name="placeholderPropDescription"
						[onkeyup]="widget.placeholderDescription_Keyup" 
						[onchange]="widget.placeholderDescription_Change"
						[value]="placeholderPropDescription"></ez-text>
			<ez-text label="{{_('Placeholder hours')}}"
						name="placeholderPropHour"
						[onkeyup]="widget.placeholderHour_Keyup" 
						[onchange]="widget.placeholderHour_Change"
						[value]="placeholderPropHour"></ez-text>
						
			<ez-select name="reportStatus" 
						label="{{_('Report status')}}"
						[onchange]="widget.reportStatus_Change" 
						[value]="reportStatus">
				<option value="open">{{_('reportStatus.open')}}</option>
				<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
				<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
				<option value="processed">{{_('reportStatus.processed')}}</option>
			</ez-select>

		</div>
	`;

	
	container = null;
	
	ref = '';
	name = '';
	label = '';
	value = '';
	reportStatus = 'open';
	placeholderDescription = _('Hours...');
	placeholderHour = '0';
	
	callback_propertyChanged = null;
	
	
	constructor( opts ) {
		opts = opts ? opts : {};
		
		if (opts.ref) this.ref = opts.ref;
		
		this.name = opts.name;
		this.label = opts.widgetLabel;
		this.value = opts.widgetValue1;
		
		if (opts.reportStatus)
			this.reportStatus = opts.reportStatus;
		
		let props = parse_json( opts.properties );
		if (props) {
			this.placeholderDescription = props.placeholderDescription;
			this.placeholderHour = props.placeholderHour;
			if (props.ref) this.ref = props.ref;
		}
	}
	
	setCallbackPropertyChanged( c ) {
		this.callback_propertyChanged = c;
	}
	
	
	getData() {
		this.label = trim( $(this.container).find('.input-hour-description').val() );
		this.value = trim( $(this.container).find('.input-hour-value').val() );

		let d = {};
		d['type'] = 'SFHourWidget';
		d['ref'] = this.ref;
		d['name'] = this.name;
		d['label'] = this.label;
		d['value1'] = this.value;
		d['placeholderDescription'] = this.placeholderDescription;
		d['placeholderHour'] = this.placeholderHour;
		d['reportStatus'] = this.reportStatus;
		
		return d;
	}
	
	
	renderEdit( container ) {
		return this.render(container);
	}
	
	render( container ) {
		this.container = container;
		
		let eztpl = new EzTemplate( container );
		eztpl.loadHtml(this.tpl);
		eztpl.setObject('widget', this);
		eztpl.setVar('name', this.name);
		eztpl.setVar('label', this.label);
		eztpl.setVar('value', this.value);
		eztpl.setVar('placeholderDescription', this.placeholderDescription);
		eztpl.setVar('placeholderHour', this.placeholderHour);
		
		eztpl.render();
	}
	
	
	reportStatus_Change( evt, obj ) {
		this.reportStatus = $('.sf-hour-props select[name=reportStatus]').val();
		
		if (this.callback_propertyChanged != null)
			this.callback_propertyChanged();
	}
	
	placeholderDescription_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropDescription]').val() );
		this.placeholderDescription = placeholderText;
		$(this.container).find('.input-hour-description').attr('placeholder', placeholderText);
	}
	
	placeholderDescription_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	placeholderHour_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropHour]').val() );
		this.placeholderHour = placeholderText;
		$(this.container).find('.input-hour-value').attr('placeholder', placeholderText);
	}
	
	placeholderHour_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	hourDescription_Change( evt, obj ) {
		obj.value = trim(obj.value);
	}
	
	
	
	renderProps() {
		let t = new EzTemplate( '.sf-props .property-list' );
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		
		t.setVar('reportStatus', this.reportStatus);
		t.setVar('placeholderPropDescription', this.placeholderDescription);
		t.setVar('placeholderPropHour', this.placeholderHour);
		
		t.render();
	}
	
		
}

