

export class SFMoneyLabelWidget {

	static sf_counter = 1;
	
	widgetDescription = _('Amount money');
	
	tpl = `
		<div class="sf-money-label-widget">
			<label for="sfm_{{uid}}" 
					class="sf-money-label" style="display: block;">{{label??'&nbsp;'}}</label>
			<input type="text" 
					id="sfm_{{uid}}"
					class="input-money-value" 
					name="{{format_price(this.name+'_value', true)}}"
					[placeholder]="placeholderAmount"
					[value]="value" />
		</div>
	`;
	
	tplProps = `
		<div class="sf-money-label-props">
			<ez-text label="{{_('Label')}}"
						name="label"
						[onkeyup]="widget.label_Keyup" 
						[onchange]="widget.label_Change"
						[value]="label"></ez-text>
			<ez-text label="{{_('Placeholder amount')}}"
						name="placeholderPropAmount"
						[onkeyup]="widget.placeholderAmount_Keyup" 
						[onchange]="widget.placeholderAmount_Change"
						[value]="placeholderPropAmount"></ez-text>
		
			<ez-select name="reportStatus" 
						label="{{_('Report status')}}"
						[onchange]="widget.reportStatus_Change" 
						[value]="reportStatus">
				<option value="open">{{_('reportStatus.open')}}</option>
				<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
				<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
				<option value="processed">{{_('reportStatus.processed')}}</option>
			</ez-select>
		</div>
	`;

	
	container = null;
	
	uid = null;
	
	ref = '';
	name = '';
	label = _('Money amount...');
	value = '';
	placeholderAmount = '€ 0,00';
	reportStatus = 'open';
	
	callback_propertyChanged = null;
	
	
	constructor( opts ) {
		opts = opts ? opts : {};
		
		if (opts.ref) this.ref = opts.ref;
		
		if (opts.widgetLabel)
			this.label = opts.widgetLabel;
		if (opts.widgetValue1)
			this.value = opts.widgetValue1;
		
		if (opts.reportStatus)
			this.reportStatus = opts.reportStatus;
		
//		this.name = opts.name;
//		this.label = opts.label;
//		this.value = opts.value;
		let props = parse_json( opts.properties );
		if (props) {
			this.placeholderAmount = props.placeholderAmount;
			if (props.ref) this.ref = props.ref;
		}
		
		this.uid = SFMoneyLabelWidget.sf_counter++;
	}
	

	setCallbackPropertyChanged( c ) {
		this.callback_propertyChanged = c;
	}

	
	getData() {
		this.value = trim( $(this.container).find('.input-money-value').val() );

		let d = {};
		d['type'] = 'SFMoneyLabelWidget';
		d['ref'] = this.ref;
		d['name'] = this.name;
		d['label'] = this.label;
		d['value1'] = this.value;
		d['placeholderAmount'] = this.placeholderAmount;
		d['reportStatus'] = this.reportStatus;
		
		return d;
	}
	
	
	renderEdit( container ) {
		return this.render(container);
	}
	
	render( container ) {
		this.container = container;
		
		let eztpl = new EzTemplate( container );
		eztpl.loadHtml(this.tpl);
		eztpl.setVar('name', this.name);
		eztpl.setVar('label', this.label);
		eztpl.setVar('value', this.value);
		eztpl.setVar('placeholderAmount', this.placeholderAmount);
		eztpl.setVar('uid', this.uid);
		
		eztpl.render();
		
		$(container).find('.input-money-value').on('focus', function() {
			let v = this.value;
			this.value = strtodouble(v);
			this.type = 'number';
			
			this.dispatchEvent(new Event('click', { bubbles: true }));
		});
		$(container).find('.input-money-value').on('blur', function() {
			let v = this.value;
			this.type = 'text';
			if (v != '')
				this.value = format_price(v, true);
		});
	}
	
	reportStatus_Change( evt, obj ) {
		this.reportStatus = $('.sf-money-label-props select[name=reportStatus]').val();
		
		if (this.callback_propertyChanged != null)
			this.callback_propertyChanged();
	}


	label_Keyup(evt, obj) {
		let label = trim( $(obj).find('input[name=label]').val() );
		this.label = label;
		$(this.container).find('.sf-money-label').text( label );
	}
	label_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	placeholderAmount_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropAmount]').val() );
		this.placeholderAmount = placeholderText;
		$(this.container).find('.input-money-value').attr('placeholder', placeholderText);
	}
	
	placeholderAmount_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}



	renderProps() {
		let t = new EzTemplate( '.sf-props .property-list' );
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		
		t.setVar('label', this.label);
		t.setVar('placeholderPropAmount', this.placeholderAmount);
		t.setVar('reportStatus', this.reportStatus);
		
		t.render();
	}

	
}

