

export class SFMoneyWidget {
	
	widgetDescription = _('Amount money');
	
	tpl = `
		<div class="sf-money-widget">
			<input type="text"
					class="input-money-description"
					[placeholder]="placeholderDescription"
					[onchange]="widget.moneyDescription_Change"
					name="{{name}}"
					[value]="label" />
			<input type="text" 
					class="input-money-value" 
					name="{{format_price(this.name+'_value', true)}}"
					[placeholder]="placeholderAmount"
					[value]="value" />
		</div>
	`;
	
	tplProps = `
		<div class="sf-money-props">
			<ez-text label="{{_('Placeholder description')}}"
						name="placeholderPropDescription"
						[onkeyup]="widget.placeholderDescription_Keyup"
						[onchange]="widget.placeholderDescription_Change"
						[value]="placeholderPropDescription"></ez-text>
			<ez-text label="{{_('Placeholder amount')}}"
						name="placeholderPropAmount"
						[onkeyup]="widget.placeholderAmount_Keyup"
						[onchange]="widget.placeholderAmount_Change"
						[value]="placeholderPropAmount"></ez-text>

			<ez-select name="reportStatus" 
						label="{{_('Report status')}}"
						[onchange]="widget.reportStatus_Change" 
						[value]="reportStatus">
				<option value="open">{{_('reportStatus.open')}}</option>
				<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
				<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
				<option value="processed">{{_('reportStatus.processed')}}</option>
			</ez-select>
		</div>
	`;

	
	container = null;
	
	ref = '';
	name = '';
	label = '';
	value = '';
	placeholderDescription = _('Money amount...');
	placeholderAmount = '€ 0,00';
	reportStatus = 'open';
	
	callback_propertyChanged = null;
	
	constructor( opts ) {
		opts = opts ? opts : {};
		
		if (opts.ref) this.ref = opts.ref;
		
		if (opts.widgetLabel)
			this.label = opts.widgetLabel;
		if (opts.widgetValue1)
			this.value = opts.widgetValue1;
		
		if (opts.reportStatus)
			this.reportStatus = opts.reportStatus;
		
//		this.name = opts.name;
//		this.label = opts.label;
//		this.value = opts.value;
		let props = parse_json( opts.properties );
		if (props) {
			this.placeholderDescription = props.placeholderDescription;
			this.placeholderAmount = props.placeholderAmount;
			if (props.ref) this.ref = props.ref;
		}
		
	}
	

	setCallbackPropertyChanged( c ) {
		this.callback_propertyChanged = c;
	}

	
	
	getData() {
		this.label = trim( $(this.container).find('.input-money-description').val() );
		this.value = trim( $(this.container).find('.input-money-value').val() );

		let d = {};
		d['type'] = 'SFMoneyWidget';
		d['ref'] = this.ref;
		d['name'] = this.name;
		d['label'] = this.label;
		d['value1'] = this.value;
		d['placeholderDescription'] = this.placeholderDescription;
		d['placeholderAmount'] = this.placeholderAmount;
		d['reportStatus'] = this.reportStatus;
		
		return d;
	}
	
	
	renderEdit( container ) {
		return this.render(container);
	}
	
	render( container ) {
		this.container = container;
		
		let eztpl = new EzTemplate( container );
		eztpl.loadHtml(this.tpl);
		eztpl.setObject('widget', this);
		eztpl.setVar('name', this.name);
		eztpl.setVar('label', this.label);
		eztpl.setVar('value', this.value);
		eztpl.setVar('placeholderDescription', this.placeholderDescription);
		eztpl.setVar('placeholderAmount', this.placeholderAmount);
		
		eztpl.render();
		
		$(container).find('.input-money-value').on('focus', function( evt ) {
			let v = this.value;
			this.value = strtodouble(v);
			this.type = 'number';
			
			this.dispatchEvent(new Event('click', { bubbles: true }));
		});
		$(container).find('.input-money-value').on('blur', function() {
			let v = this.value;
			this.type = 'text';
			
			if (v != '')
				this.value = format_price(v, true);
		});
	}
	
	
	
	moneyDescription_Change( evt, obj ) {
		obj.value = trim(obj.value);
	}
	
	
	reportStatus_Change( evt, obj ) {
		this.reportStatus = $('.sf-money-props select[name=reportStatus]').val();
		
		if (this.callback_propertyChanged != null)
			this.callback_propertyChanged();
	}


	placeholderDescription_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropDescription]').val() );
		this.placeholderDescription = placeholderText;
		$(this.container).find('.input-money-description').attr('placeholder', placeholderText);
	}
	
	placeholderDescription_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	placeholderAmount_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropAmount]').val() );
		this.placeholderAmount = placeholderText;
		$(this.container).find('.input-money-value').attr('placeholder', placeholderText);
	}
	placeholderAmount_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	


	renderProps() {
		let t = new EzTemplate( '.sf-props .property-list' );
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		
		t.setVar('placeholderPropDescription', this.placeholderDescription);
		t.setVar('placeholderPropAmount', this.placeholderAmount);
		
		t.setVar('reportStatus', this.reportStatus);
		
		t.render();
	}

	
}

