

export class SFNoteWidget {
	
	widgetDescription = _('Note');
	
	tpl = `
		<div class="sf-note-widget">
			<label class="note-label" style="display: block;">{{label??'&nbsp;'}}</label>
			<textarea [name]="name" 
						class="input-note"
						[onchange]="widget.value_Change"
						[onkeyup]="widget.value_Change"
						[placeholder]="placeholder"
						[contentText]="value"></textarea>
		</div>
	`;
	
	tplProps = `
		<div class="sf-note-props">
			<ez-text label="Label"
						name="label"
						[onkeyup]="widget.label_Change" 
						[value]="label"></ez-text>
			<ez-text label="{{_('Placeholder')}}"
						name="placeholder"
						[onkeyup]="widget.placeholder_Change" 
						[value]="placeholderText"></ez-text>
		</div>
	`;
	
	
	container = null;
	
	ref = '';
	
	name = '';
	label = _('Note...');
	value = '';
	placeholder = '';
	
	callback_propertyChanged = null;
	
	
	
	constructor( opts ) {
		opts = opts ? opts : {};
		
		if (opts.ref) this.ref = opts.ref;
		
		if (opts.widgetLabel)
			this.label = opts.widgetLabel;
		if (opts.widgetValue1)
			this.value = opts.widgetValue1;
		
		let props = parse_json( opts.properties );
		if (props) {
			this.placeholder = props.placeholder;
			if (props.ref) this.ref = props.ref;
		}
	
	}
	
	

	setCallbackPropertyChanged( c ) {
		this.callback_propertyChanged = c;
	}
	
	
	getData() {
		let d = {};
		d['type'] = 'SFNoteWidget';
		d['ref'] = this.ref;
		d['name'] = this.name;
		d['label'] = this.label;
		d['value1'] = this.value;
		d['placeholder'] = this.placeholder;
		
		return d;
	}
	
	
	renderEdit( container ) {
		return this.render(container);
	}
	
	render( container ) {
		this.container = container;
		
		let eztpl = new EzTemplate( container );
		eztpl.loadHtml(this.tpl);
		eztpl.setObject('widget', this);
		eztpl.setVar('name', this.name);
		eztpl.setVar('label', this.label);
		eztpl.setVar('value', this.value);
		eztpl.setVar('placeholder', this.placeholder);
		
		eztpl.render();
	}
	
	
	label_Change() {
		let l = $('.sf-note-props input[name=label]').val();
		
		this.label = l;
		$(this.container).find('.note-label').text( l );
	}
	
	value_Change() {
		let v = $(this.container).find('textarea').val();
		this.value = v;
	}
	
	placeholder_Change(evt, obj) {
		let placeholder = trim( $(obj).find('input[name=placeholder]').val() );
		this.placeholder = placeholder;
		$(this.container).find('.input-note').attr('placeholder', placeholder);
	}

	
	renderProps() {
		let t = new EzTemplate( '.sf-props .property-list' );
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		
//		t.setVar('name', this.name);
		t.setVar('label', this.label);
		t.setVar('value', this.value);
		t.setVar('placeholderText', this.placeholder);
		
		t.render();
	}
	
	
}

