
export class SFNumberLabelWidget {
	
	static sf_counter = 1;

	widgetDescription = _('Numbers');
	
	
	tpl = `
		<div class="sf-number-label-widget">
			<label for="sfh_{{uid}}" class="sf-number-label" style="display: block;">{{label??'&nbsp;'}}</label>
			<input type="number" 
					id="sfh_{{uid}}" 
					class="input-number-value"
					name="{{name+'_value'}}"
					[min]="minValue"
					[max]="maxValue"
					[placeholder]="placeholderNumber"
					[value]="value" />
		</div>
	`;
	
	tplProps = `
		<div class="sf-number-label-props">
			<ez-text label="{{_('Label')}}"
						name="label"
						[onkeyup]="widget.label_Keyup" 
						[onchange]="widget.label_Change"
						[value]="label"></ez-text>
			<ez-text label="{{_('Placeholder numbers')}}"
						name="placeholderPropNumber"
						[onkeyup]="widget.placeholderNumber_Keyup" 
						[onchange]="widget.placeholderNumber_Change"
						[value]="placeholderPropNumber"></ez-text>
			<ez-number label="{{_('Min')}}"
						name="sf-number-minValue"
						[onchange]="widget.minValue_Change"
						[value]="minValue"></ez-number>
			<ez-number label="{{_('Max')}}"
						name="sf-number-maxValue"
						[onchange]="widget.maxValue_Change"
						[value]="maxValue"></ez-number>
			
			<ez-select name="reportStatus" 
						label="{{_('Report status')}}"
						[onchange]="widget.reportStatus_Change" 
						[value]="reportStatus">
				<option value="open">{{_('reportStatus.open')}}</option>
				<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
				<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
				<option value="processed">{{_('reportStatus.processed')}}</option>
			</ez-select>
		</div>
	`;

	
	container = null;
	
	uid = null;
	
	ref = '';
	
	name = '';
	label = _('Numbers...');
	value = '';
	minValue = '';
	maxValue = '';
	reportStatus = 'open';
	
	placeholderNumber = '0';
	
	callback_propertyChanged = null;
	
	
	constructor( opts ) {
		opts = opts ? opts : {};
		this.name = opts.name;
		
		if (opts.ref) this.ref = opts.ref;
		
		if (opts.widgetLabel)
			this.label = opts.widgetLabel;
		if (opts.widgetValue1)
			this.value = opts.widgetValue1;
		if (opts.reportStatus)
			this.reportStatus = opts.reportStatus;
		
		let props = parse_json( opts.properties );
		if (props) {
			this.placeholderNumber = props.placeholderNumber;
			this.minValue = props.minValue;
			this.maxValue = props.maxValue;
			if (props.ref) this.ref = props.ref;
		}
		
		this.uid = SFNumberLabelWidget.sf_counter++;
	}
	
	
	setCallbackPropertyChanged( c ) {
		this.callback_propertyChanged = c;
	}
	
	
	getData() {
		this.value = trim( $(this.container).find('.input-number-value').val() );

		let d = {};
		d['type'] = 'SFNumberLabelWidget';
		d['ref'] = this.ref;
		d['name'] = this.name;
		d['label'] = this.label;
		d['value1'] = this.value;
		d['placeholderNumber'] = this.placeholderNumber;
		d['minValue'] = this.minValue;
		d['maxValue'] = this.maxValue;
		d['reportStatus'] = this.reportStatus;
		
		return d;
	}
	
	
	renderEdit( container ) {
		return this.render(container);
	}
	
	render( container ) {
		this.container = container;
		
		let eztpl = new EzTemplate( container );
		eztpl.loadHtml(this.tpl);
		eztpl.setVar('name', this.name);
		eztpl.setVar('label', this.label);
		eztpl.setVar('value', this.value);
		eztpl.setVar('placeholderNumber', this.placeholderNumber);
		eztpl.setVar('uid', this.uid);
		eztpl.setVar('minValue', this.minValue);
		eztpl.setVar('maxValue', this.maxValue);
		
		eztpl.render();
	}
	
	reportStatus_Change( evt, obj ) {
		this.reportStatus = $('.sf-number-label-props select[name=reportStatus]').val();
		
		if (this.callback_propertyChanged != null)
			this.callback_propertyChanged();
	}

	
	label_Keyup(evt, obj) {
		let label = trim( $(obj).find('input[name=label]').val() );
		this.label = label;
		$(this.container).find('.sf-number-label').text( label );
	}
	
	label_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	placeholderNumber_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropNumber]').val() );
		this.placeholderNumber = placeholderText;
		$(this.container).find('.input-number-value').attr('placeholder', placeholderText);
	}
	placeholderNumber_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	minValue_Change(evt, obj) {
		let v = trim( $(obj).find('input[name=sf-number-minValue]').val() );
		this.minValue = v;
		$(this.container).find('.input-number-value').attr('min', v);
		
	}
	maxValue_Change(evt, obj) {
		let v = trim( $(obj).find('input[name=sf-number-maxValue]').val() );
		this.maxValue = v;
		$(this.container).find('.input-number-value').attr('max', v);
	}
	
	
	
	renderProps() {
		let t = new EzTemplate( '.sf-props .property-list' );
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		
		t.setVar('label', this.label);
		t.setVar('placeholderPropNumber', this.placeholderNumber);
		t.setVar('minValue', this.minValue);
		t.setVar('maxValue', this.maxValue);
		t.setVar('reportStatus', this.reportStatus);
		
		t.render();
	}
	
		
}

