

export class SFNumberWidget {
	
	widgetDescription = _('Numbers');
	
	
	tpl = `
		<div class="sf-number-widget">
			<input type="text" 
					class="input-number-description"
					[placeholder]="placeholderDescription" 
					[onchange]="widget.description_Change"
					name="{{name}}"
					[value]="label" />
			<input type="number" 
					class="input-number-value"
					name="{{name+'_value'}}"
					[min]="minValue"
					[max]="maxValue"
					[placeholder]="placeholderNumber"
					[value]="value" />
		</div>
	`;
	
	tplProps = `
		<div class="sf-number-props">
			<ez-text label="{{_('Placeholder description')}}"
						name="placeholderPropDescription"
						[onkeyup]="widget.placeholderDescription_Keyup" 
						[onchange]="widget.placeholderDescription_Change"
						[value]="placeholderPropDescription"></ez-text>
			<ez-text label="{{_('Placeholder numbers')}}"
						name="placeholderPropNumber"
						[onkeyup]="widget.placeholderNumber_Keyup" 
						[onchange]="widget.placeholderNumber_Change"
						[value]="placeholderPropNumber"></ez-text>
			<ez-number label="{{_('Min')}}"
						name="sf-number-minValue"
						[onchange]="widget.minValue_Change"
						[value]="minValue"></ez-number>
			<ez-number label="{{_('Max')}}"
						name="sf-number-maxValue"
						[onchange]="widget.maxValue_Change"
						[value]="maxValue"></ez-number>

			<ez-select name="reportStatus" 
						label="{{_('Report status')}}"
						[onchange]="widget.reportStatus_Change" 
						[value]="reportStatus">
				<option value="open">{{_('reportStatus.open')}}</option>
				<option value="inprogress">{{_('reportStatus.inprogress')}}</option>
				<option value="cancelled">{{_('reportStatus.cancelled')}}</option>
				<option value="processed">{{_('reportStatus.processed')}}</option>
			</ez-select>

		</div>
	`;

	
	container = null;
	
	ref = '';
	name = '';
	label = '';
	value = '';
	minValue = '';
	maxValue = '';
	
	placeholderDescription = _('Numbers...');
	placeholderNumber = '0';
	reportStatus = 'open';
	
	callback_propertyChanged = null;
	
	
	constructor( opts ) {
		opts = opts ? opts : {};
		
		if (opts.ref) this.ref = opts.ref;
		
		this.name = opts.name;
		this.label = opts.widgetLabel;
		this.value = opts.widgetValue1;
		
		if (opts.reportStatus)
			this.reportStatus = opts.reportStatus;
		
		let props = parse_json( opts.properties );
		if (props) {
			this.placeholderDescription = props.placeholderDescription;
			this.placeholderNumber = props.placeholderNumber;
			this.minValue = props.minValue;
			this.maxValue = props.maxValue;
			if (props.ref) this.ref = props.ref;
		}
		
	}
	
	
	setCallbackPropertyChanged( c ) {
		this.callback_propertyChanged = c;
	}
	
	getData() {
		this.label = trim( $(this.container).find('.input-number-description').val() );
		this.value = trim( $(this.container).find('.input-number-value').val() );

		let d = {};
		d['type'] = 'SFNumberWidget';
		d['ref'] = this.ref;
		d['name'] = this.name;
		d['label'] = this.label;
		d['value1'] = this.value;
		d['placeholderDescription'] = this.placeholderDescription;
		d['placeholderNumber'] = this.placeholderNumber;
		d['minValue'] = this.minValue;
		d['maxValue'] = this.maxValue;
		d['reportStatus'] = this.reportStatus;
		
		return d;
	}
	
	
	renderEdit( container ) {
		return this.render(container);
	}
	
	render( container ) {
		this.container = container;
		
		let eztpl = new EzTemplate( container );
		eztpl.loadHtml(this.tpl);
		eztpl.setObject('widget', this);
		eztpl.setVar('name', this.name);
		eztpl.setVar('label', this.label);
		eztpl.setVar('value', this.value);
		eztpl.setVar('placeholderDescription', this.placeholderDescription);
		eztpl.setVar('placeholderNumber', this.placeholderNumber);
		eztpl.setVar('minValue', this.minValue);
		eztpl.setVar('maxValue', this.maxValue);
		
		eztpl.render();
	}
	
	reportStatus_Change( evt, obj ) {
		this.reportStatus = $('.sf-number-props select[name=reportStatus]').val();
		
		if (this.callback_propertyChanged != null)
			this.callback_propertyChanged();
	}

	
	description_Change( evt, obj ) {
		obj.value = trim(obj.value);
	}
	
	placeholderDescription_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropDescription]').val() );
		this.placeholderDescription = placeholderText;
		$(this.container).find('.input-number-description').attr('placeholder', placeholderText);
	}
	placeholderDescription_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	placeholderNumber_Keyup(evt, obj) {
		let placeholderText = trim( $(obj).find('input[name=placeholderPropNumber]').val() );
		this.placeholderNumber = placeholderText;
		$(this.container).find('.input-number-value').attr('placeholder', placeholderText);
	}
	placeholderNumber_Change(evt, obj) {
		let o = obj.querySelector('input[type=text]');
		o.value = trim(o.value);
	}
	
	minValue_Change(evt, obj) {
		let v = trim( $(obj).find('input[name=sf-number-minValue]').val() );
		this.minValue = v;
		$(this.container).find('.input-number-value').attr('min', v);
		
	}
	maxValue_Change(evt, obj) {
		let v = trim( $(obj).find('input[name=sf-number-maxValue]').val() );
		this.maxValue = v;
		$(this.container).find('.input-number-value').attr('max', v);
	}
	
	
	renderProps() {
		let t = new EzTemplate( '.sf-props .property-list' );
		t.loadHtml( this.tplProps );
		t.setObject('widget', this);
		
		t.setVar('placeholderPropDescription', this.placeholderDescription);
		t.setVar('placeholderPropNumber', this.placeholderNumber);
		t.setVar('minValue', this.minValue);
		t.setVar('maxValue', this.maxValue);
		t.setVar('reportStatus', this.reportStatus);
		
		t.render();
	}
	
		
}

