
import { SFNoteWidget }  from './SFNoteWidget.js';
import { SFHourWidget }  from './SFHourWidget.js';
import { SFHourLabelWidget }  from './SFHourLabelWidget.js';
import { SFMoneyWidget } from './SFMoneyWidget.js';
import { SFMoneyLabelWidget } from './SFMoneyLabelWidget.js';
import { SFNumberWidget }  from './SFNumberWidget.js';
import { SFNumberLabelWidget }  from './SFNumberLabelWidget.js';
import { SFCheckboxWidget } from './SFCheckboxWidget.js';



export function listSimpleFormWidgets() {

	let widgets = [];
	
	widgets.push({
		class: SFNoteWidget,
		name: 'SFNoteWidget',
		description: _('Note')
	});
	widgets.push({
		class: SFHourWidget,
		name: 'SFHourWidget',
		description: _('Hours')
	});
	widgets.push({
		class: SFMoneyWidget,
		name: 'SFMoneyWidget',
		description: _('Amount money')
	});
	widgets.push({
		class: SFNumberWidget,
		name: 'SFNumberWidget',
		description: _('Numbers')
	});
	
	widgets.push({
		class: SFHourLabelWidget,
		name: 'SFHourLabelWidget',
		description: _('Hours (label)'),
		descriptionHtml: _('Hours') + ' <span class="small-note">(label)</span>' 
	});
	widgets.push({
		class: SFMoneyLabelWidget,
		name: 'SFMoneyLabelWidget',
		description: _('Amount money (label)'),
		descriptionHtml: _('Amount money') + ' <span class="small-note">(label)</span>'
	});
	
	widgets.push({
		class: SFNumberLabelWidget,
		name: 'SFNumberLabelWidget',
		description: _('Numbers (label)'),
		descriptionHtml: _('Numbers') + ' <span class="small-note">(label)</span>' 
	});

	widgets.push({
		class: SFCheckboxWidget,
		name: 'SFCheckboxWidget',
		description: _('Checkbox')
	});
	
	return widgets;
}


export function lookupSimpleFormWidget( widgetName ) {
	let widgets = listSimpleFormWidgets();
	
	for(let i=0; i < widgets.length; i++) {
		if ( widgets[i].name == widgetName )
			return widgets[i];
	}
	
	return null;
}


