

function rtob_has_permission( permissionName ) {
	
	if (!toolboxConfig.user || toolboxConfig.user == null || !toolboxConfig.user.permissions)
		return false;
	
	if (toolboxConfig.user.isAdmin)
		return true;
	
	for(let i=0; i < toolboxConfig.user.permissions.length; i++) {
		let p = toolboxConfig.user.permissions[i];
		
		if (p.refObject == permissionName || p.refObject == 'up.'+permissionName) {
			if (p.accessMethod == 'full' || p.accessMethod == 'restricted') {
				return true;
			}
		}
	}
	
	return false;
}


add_filter('MenuWidget.menuItems', (menuItems) => {
	
	if (rtob_has_permission('up.rtob_work_orders'))
		menuItems.push({ sort: 800, url: '/work/', label: _('Work orders') });
	
	if (rtob_has_permission('up.rtob_work_hours'))
		menuItems.push({ sort: 810, url: '/hour/', label: _('Hours') });
	
	if (rtob_has_permission('up.rtob_work_feedback'))
		menuItems.push({ sort: 820, url: '/feedback/', label: 'Leads / Acties' });
	
	if (toolboxConfig.user && toolboxConfig.user.isAdmin)
		menuItems.push({ sort: 850, url: '/reporting/', label: _('Reporting') });
	
//	menuItems.push({ sort: 810, url: '/simpleforms/', label: 'Forms' });
	
	return menuItems;
});

add_filter('MasterData.menuItems', (menuItems) => {
	
	for(let i in menuItems) {
		if (menuItems[i].code == 'misc') {
			menuItems[i].items.push({
				url: '/masterdata/authrequests/',
				label: _('App authentication requests')
			});
		}
	}
	
	
	menuItems.push({
		'label': 'Report2Base',
		items: [
			{ url: '/masterdata/rtobsettings/', label: 'Algemene instellingen' }
			, { url: '/masterdata/relay/', label: 'Relay instellingen' }
		]
	});
	
	return menuItems;
});


add_filter('MasterData.UserEditWidget.userPermissions', (userPermissions) => {
	userPermissions.push({
		label: _('Work orders'),
		name: 'rtob_work_orders',
		values: [
			{   value: 'full', 			label: 'Volledig', selected: true }
			, { value: 'restricted', 	label: 'Toegewezen' }
			, { value: 'none', 			label: 'Geen' }
		]
	});
	
	userPermissions.push({
		label: _('Hours'),
		name: 'rtob_work_hours',
		values: [
			{   value: 'full', 			label: 'Volledig', selected: true }
			, { value: 'restricted', 	label: 'Toegewezen' }
			, { value: 'none', 			label: 'Geen' }
		]
	});
	
	userPermissions.push({
		label: _('Leads / actions'),
		name: 'rtob_work_feedback',
		values: [
			{   value: 'full', 			label: 'Volledig', selected: true }
			, { value: 'restricted', 	label: 'Toegewezen' }
			, { value: 'none', 			label: 'Geen' }
		]
	});
	
	return userPermissions;
});

add_filter('AppRouter.lookupRoute', (route, url) => {
	
	let routes = [];
	
	routes.push( { url: '/', 							widget: 'rtob/RtobDashboardWidget' } );
	
	routes.push( { url: '/rtob/register/',				widget: 'rtob/RegisterAppWidget' } );
	
	routes.push( { url: '/masterdata/rtobsettings/', 	widget: 'rtob/masterdata/RtobSettingsWidget' } );
	routes.push( { url: '/masterdata/relay/', 			widget: 'rtob/RelaySettingsWidget' } );
	routes.push( { url: '/masterdata/authrequests/', 	widget: 'auth/AppAuthRequestWidget' } );
	
	routes.push( { url: '/work/', 						widget: 'rtob/work/WorkListWidget' } );
	routes.push( { url: '/work/edit/',					widget: 'rtob/work/WorkEditWidget' } );
	routes.push( { url: '/simpleforms/',				widget: 'simpleform/SimpleFormListWidget' } );
	routes.push( { url: '/simpleforms/edit/',			widget: 'simpleform/SimpleFormEditWidget' } );
	
	routes.push( { url: '/hour/',						widget: 'rtob/hour/WorkHourListWidget' } );
	routes.push( { url: '/hour/edit/',					widget: 'rtob/hour/WorkHourEditWidget' } );
	
	routes.push( { url: '/feedback/',					widget: 'rtob/feedback/FeedbackListWidget' } );
	routes.push( { url: '/feedback/edit/',				widget: 'rtob/feedback/FeedbackEditWidget' } );
	
	routes.push( { url: '/reporting/',					widget: 'reporting/WorkReportV1' } );
		
//	console.log('lookie jojojo', url);
	
	for(let i in routes) {
		if (routes[i].url == url || appUrl(routes[i].url) == url)
			return routes[i];
	}
	
	return route;
});

window.addEventListener('App.started', async () => {
	let r = await postJson('/service/r2b/relaysettings.do', {
		a: 'relayConfigured'
	});
	
	let json = await r.json();
	
	if (json && json.configured == false) {
		gotoRoute( '/rtob/register/' );
	}
	
	let li = $('<li class="nav-item nav-item-text text-nowrap" />');
	li.append('<a id="btn-auth-request" onclick="gotoRoute(\'/masterdata/authrequests/\');">Auth Requests</a>');
	$('.logoff-container').prepend(li);
});



window.addEventListener('websocket-message', (e) => {
	if (e && e.data == 'app_auth_request_updated') {
		// already red? => skip
		if ( $('#btn-auth-request').data('color-set') ) {
			return;
		}
		// request page? => skip
		if ($('.app-auth-request-widget').length > 0) {
			
			let p = document.querySelector('.app-auth-request-widget');
			if (p) {
				let appAuthReqWidget = p.appAuthRequestWidget;
				if (appAuthReqWidget) {
					appAuthReqWidget.checkUpdates();
				}
			}
			
			return;
		}
		
		// blink it
		$('#btn-auth-request').css('color', '#f49999');
		$('#btn-auth-request').data('color-set', true);
		$('#btn-auth-request').fadeOut().fadeIn().fadeOut().fadeIn();
	}
	
	if (e && e.data.indexOf('ObjectChanged:') === 0) {
		let el = document.querySelector('.rtob-dashboard-widget');
		if (el) {
			el.widget.handleEvent( e.data );
		}
	}
});



window.addEventListener('CustomerEditWidget.customerLoaded', async (e) => {
	// Work Order tab
	let mod1 = await import('./app/widget/rtob/work/WorkTabWidget.js');
	
	let wt = new mod1['WorkTabWidget']();
	wt.render();
	
	
	// Work Hour tab
	let mod2 = await import('./app/widget/rtob/hour/WorkHourTabWidget.js');
	let wh = new mod2['WorkHourTabWidget']();
	wh.render();
	
	// Feedback tab
	let mod3 = await import('./app/widget/rtob/feedback/FeedbackTabWidget.js');
	let ft = new mod3['FeedbackTabWidget']();
	ft.render();
	
});

window.addEventListener('UserEditWidget.userLoaded', async () => {
	let mod1 = await import('./app/events/UserActionEvents.js');
	
	new mod1['UserActionEvents']();
	
});



