


document.addEventListener('DOMContentLoaded', () => {
	
	if (!toolboxConfig.user)
		return;
	
	init_ws();
});


let ws_timeout = null;
let do_reconnect_ws = () => {
	if (ws_timeout != null)
		clearTimeout(ws_timeout);
	
	ws_timeout = setTimeout(() => {
		init_ws();
	}, 2500);
};


let init_ws = () => {
	
	let url = window.location.href.toString();
	url = url.replace('https://', 'wss://');
	url = url.replace('http://', 'ws://');
	
	let firstslash = url.substring(6).indexOf('/') + 6;		// substring() to skip 'ws?://'
	url = url.substring(0, firstslash) + toolboxConfig.contextPath;
	
	let ws = new WebSocket( url + '/ws/updatelistener.do' );
	
	ws.onmessage = (evt) => {
//		console.log('WebSocket message', evt.data);
		
		
		let e = new Event( 'websocket-message' );
		e.data = evt.data;
		dispatchEvent( e );
	}
	
	ws.addEventListener('open', (evt) => {
		let jtbauth = getCookie('jtbauth');
		
		ws.send('jtbauth:' + jtbauth);
	});
	
	
	ws.addEventListener('error', (evt) => {
		// close
		if (ws) {
			ws.close();
		}
		
		// handle reconnect
		do_reconnect_ws();
		
	});
	ws.addEventListener('close', (evt) => {
		// handle reconnect
		do_reconnect_ws();
	});
};

